/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.groovy;

import com.cleanroommc.groovyscript.api.GroovyBlacklist;
import com.cleanroommc.groovyscript.api.GroovyLog;
import com.nomiceu.nomilabs.NomiLabs;
import com.nomiceu.nomilabs.config.LabsConfig;
import com.nomiceu.nomilabs.groovy.mixinhelper.AccessibleKeyBinding;
import com.nomiceu.nomilabs.mixin.vanilla.KeyBindingAccessor;
import com.nomiceu.nomilabs.tooltip.LabsTooltipHelper;
import com.nomiceu.nomilabs.util.LabsGroovyHelper;
import com.nomiceu.nomilabs.util.LabsTranslate;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.settings.KeyModifier;

@GroovyBlacklist
public class KeyBindingHelper {
    public static void drawKeybindingTooltip(int mouseX, int mouseY, FontRenderer fontRenderer, KeyBinding keybinding) {
        int spacing;
        fontRenderer.func_78276_b(LabsTranslate.translate(keybinding.func_151466_e(), new Object[0]), mouseX + 10, mouseY, 0xFFFFFF);
        int currentSpacing = spacing = fontRenderer.field_78288_b;
        if (LabsTooltipHelper.isShiftDown() && LabsConfig.advanced.controlMenuTooltipSettings.showID) {
            fontRenderer.func_78276_b(keybinding.func_151464_g(), mouseX + 10, mouseY + spacing, 0x808080);
            currentSpacing += spacing;
        }
        if (LabsTooltipHelper.isCtrlDown() && LabsConfig.advanced.controlMenuTooltipSettings.showClass) {
            fontRenderer.func_78276_b(keybinding.getClass().getName(), mouseX + 10, mouseY + currentSpacing, 0x505050);
        }
    }

    public static boolean invalidID(String id) {
        if (!KeyBindingAccessor.getKeybindRegistry().containsKey(id)) {
            LabsGroovyHelper.throwOrGroovyLog(new IllegalArgumentException("Keybind with ID " + id + " was not found!"));
            NomiLabs.LOGGER.info("Available Keybind IDs: {}", KeyBindingAccessor.getKeybindRegistry().keySet());
            GroovyLog.get().info((Object)("Available Keybind IDs: " + KeyBindingAccessor.getKeybindRegistry().keySet()));
            return true;
        }
        return false;
    }

    public static KeybindOverrideSpecification getExisting(String id) {
        KeyBinding existing = KeyBindingAccessor.getKeybindRegistry().get(id);
        return new KeybindOverrideSpecification(id, existing.getKeyModifierDefault(), existing.func_151469_h());
    }

    public static void addKeybindOverride(String id, KeyModifier modifier, int keyCode) {
        ((AccessibleKeyBinding)KeyBindingAccessor.getKeybindRegistry().get(id)).setDefaultKeyModifierAndCode(modifier, keyCode);
    }

    public static class KeybindOverrideSpecification {
        private final String id;
        private final KeyModifier modifier;
        private final int keyCode;

        public KeybindOverrideSpecification(String id, KeyModifier modifier, int keyCode) {
            this.id = id;
            this.modifier = modifier;
            this.keyCode = keyCode;
        }

        public String getId() {
            return this.id;
        }

        public KeyModifier getModifier() {
            return this.modifier;
        }

        public int getKeyCode() {
            return this.keyCode;
        }
    }
}

