/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.groovy;

import com.cleanroommc.groovyscript.registry.AbstractReloadableStorage;
import com.cleanroommc.groovyscript.registry.VirtualizedRegistry;
import com.nomiceu.nomilabs.groovy.ChangeComposition;
import com.nomiceu.nomilabs.groovy.CompositionBuilder;
import com.nomiceu.nomilabs.groovy.KeyBindingHelper;
import com.nomiceu.nomilabs.groovy.RecyclingHelper;
import com.nomiceu.nomilabs.mixin.gregtech.OreDictUnifierAccessor;
import com.nomiceu.nomilabs.util.ItemMeta;
import com.nomiceu.nomilabs.util.LabsGroovyHelper;
import gregtech.api.recipes.ingredients.nbtmatch.NBTCondition;
import gregtech.api.recipes.ingredients.nbtmatch.NBTMatcher;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.stack.ItemAndMetadata;
import gregtech.api.unification.stack.ItemMaterialInfo;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.settings.KeyModifier;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class LabsVirtualizedRegistries {
    public static final ReplaceRecyclingManager REPLACE_RECYCLING_MANAGER = new ReplaceRecyclingManager();
    public static final ReplaceCompositionManager REPLACE_DECOMP_MANAGER = new ReplaceCompositionManager();
    public static final KeybindOverridesManager KEYBIND_OVERRIDES_MANAGER = new KeybindOverridesManager();

    public static class ReplaceRecyclingManager
    extends VirtualizedRegistry<RecyclingSpecification> {
        public final Map<ItemMeta, ItemMaterialInfo> needReloading = new Object2ObjectOpenHashMap();
        @Nullable
        public Map<ItemMeta, Pair<NBTMatcher, NBTCondition>> nbtConditions = null;
        private final Map<ItemMeta, Pair<NBTMatcher, NBTCondition>> addedNbtConditions = new Object2ObjectOpenHashMap();

        public void onReload() {
            this.removeScripted().forEach(spec -> {
                OreDictUnifierAccessor.getMaterialUnificationInfo().remove(new ItemAndMetadata(spec.getItemMeta().toStack()));
                this.needReloading.put(spec.getItemMeta(), null);
            });
            this.restoreFromBackup().forEach(spec -> {
                if (spec.getInfo() != null) {
                    OreDictUnifier.registerOre((ItemStack)spec.getItemMeta().toStack(), (ItemMaterialInfo)spec.getInfo());
                } else {
                    OreDictUnifierAccessor.getMaterialUnificationInfo().remove(new ItemAndMetadata(spec.getItemMeta().toStack()));
                }
                this.needReloading.put(spec.getItemMeta(), spec.getInfo());
            });
            this.addedNbtConditions.clear();
        }

        public void afterScriptLoad() {
            this.nbtConditions = this.addedNbtConditions;
            LabsGroovyHelper.LABS_GROOVY_RUNNING = true;
            RecyclingHelper.reloadRecyclingRecipes();
            LabsGroovyHelper.LABS_GROOVY_RUNNING = false;
            this.needReloading.clear();
            this.nbtConditions = null;
        }

        protected AbstractReloadableStorage<RecyclingSpecification> createRecipeStorage() {
            return new AbstractReloadableStorage<RecyclingSpecification>(){

                protected boolean compareRecipe(RecyclingSpecification a, RecyclingSpecification b) {
                    return a.getItemMeta().equals(b.getItemMeta());
                }
            };
        }

        public void registerOre(ItemStack stack, ItemMaterialInfo info) {
            ItemMeta in = new ItemMeta(stack);
            this.addBackup(new RecyclingSpecification(in, OreDictUnifier.getMaterialInfo((ItemStack)stack)));
            this.addScripted(new RecyclingSpecification(in, info));
            this.needReloading.put(in, info);
            OreDictUnifier.registerOre((ItemStack)stack, (ItemMaterialInfo)info);
        }

        public void registerNBTHandling(ItemStack stack, NBTMatcher matcher, NBTCondition condition) {
            this.addedNbtConditions.put(new ItemMeta(stack), (Pair<NBTMatcher, NBTCondition>)Pair.of((Object)matcher, (Object)condition));
        }
    }

    public static class ReplaceCompositionManager
    extends VirtualizedRegistry<CompositionBuilder.CompositionSpecification> {
        public final Deque<CompositionBuilder.CompositionSpecification> needReloading = new ArrayDeque<CompositionBuilder.CompositionSpecification>();

        public void onReload() {
            this.restoreFromBackup().forEach(ChangeComposition::restore);
        }

        public void afterScriptLoad() {
            LabsGroovyHelper.LABS_GROOVY_RUNNING = true;
            ChangeComposition.reloadCompositionRecipes();
            LabsGroovyHelper.LABS_GROOVY_RUNNING = false;
            this.needReloading.clear();
        }

        public void changeMaterialDecomp(CompositionBuilder.CompositionSpecification spec) {
            this.addBackup(spec);
            this.needReloading.addFirst(spec);
        }
    }

    public static class KeybindOverridesManager
    extends VirtualizedRegistry<KeyBindingHelper.KeybindOverrideSpecification> {
        public void onReload() {
            this.restoreFromBackup().forEach(spec -> KeyBindingHelper.addKeybindOverride(spec.getId(), spec.getModifier(), spec.getKeyCode()));
        }

        public void addOverride(String id, KeyModifier modifier, int keyCode) {
            if (KeyBindingHelper.invalidID(id)) {
                return;
            }
            this.addBackup(KeyBindingHelper.getExisting(id));
            KeyBindingHelper.addKeybindOverride(id, modifier, keyCode);
        }
    }

    public static class RecyclingSpecification {
        private final ItemMeta itemMeta;
        private final ItemMaterialInfo info;

        public RecyclingSpecification(ItemMeta itemMeta, ItemMaterialInfo info) {
            this.itemMeta = itemMeta;
            this.info = info;
        }

        public ItemMeta getItemMeta() {
            return this.itemMeta;
        }

        public ItemMaterialInfo getInfo() {
            return this.info;
        }
    }
}

