/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.groovy;

import com.cleanroommc.groovyscript.api.GroovyBlacklist;
import com.google.common.collect.ImmutableList;
import com.nomiceu.nomilabs.mixin.gregtech.FluidStorageKeyAccessor;
import com.nomiceu.nomilabs.mixin.gregtech.MetaItemsMixin;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.pipenet.block.material.IMaterialPipeType;
import gregtech.api.pipenet.block.material.ItemBlockMaterialPipe;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.ore.StoneType;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.common.blocks.MaterialItemBlock;
import gregtech.common.blocks.OreItemBlock;
import gregtech.common.pipelike.cable.Insulation;
import gregtech.common.pipelike.fluidpipe.FluidPipeType;
import gregtech.common.pipelike.itempipe.ItemPipeType;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

@GroovyBlacklist
public class MaterialHelper {
    public static final int CAPACITY = 1000;
    private static Material material;
    private static Consumer<ItemStack> action;

    public static void forMaterialItem(Material material, Consumer<ItemStack> action, boolean inclBucket) {
        MaterialHelper.material = material;
        MaterialHelper.action = action;
        MaterialHelper.forItems(MetaItemsMixin.getOrePrefixes(), MetaItem.class);
        MaterialHelper.forItemsInPipeEnum(Insulation.VALUES);
        MaterialHelper.forItemsInPipeEnum(FluidPipeType.VALUES);
        MaterialHelper.forItemsInPipeEnum(ItemPipeType.VALUES);
        MaterialHelper.forItems((List<OrePrefix>)ImmutableList.of((Object)OrePrefix.block, (Object)OrePrefix.frameGt), MaterialItemBlock.class);
        StoneType.STONE_TYPE_REGISTRY.forEach(type -> {
            if (type.shouldBeDroppedAsItem) {
                MaterialHelper.forItems(type.processingPrefix, OreItemBlock.class);
            }
        });
        if (!material.hasFluid() || !inclBucket) {
            return;
        }
        FluidStorageKeyAccessor.getKeys().values().forEach(key -> {
            Fluid fluid = material.getFluid(key);
            if (fluid == null || ForgeModContainer.getInstance().universalBucket == null) {
                return;
            }
            FluidStack fluidStack = new FluidStack(fluid, 1000);
            ItemStack itemStack = new ItemStack((Item)ForgeModContainer.getInstance().universalBucket);
            itemStack.func_77982_d(fluidStack.writeToNBT(new NBTTagCompound()));
            action.accept(itemStack);
        });
    }

    private static void forItemsInPipeEnum(IMaterialPipeType<?>[] types) {
        Arrays.stream(types).map(IMaterialPipeType::getOrePrefix).forEach(prefix -> MaterialHelper.forItems(prefix, ItemBlockMaterialPipe.class));
    }

    private static void forItems(List<OrePrefix> prefixes, Class<?> requiredClass) {
        for (OrePrefix prefix : prefixes) {
            MaterialHelper.forItems(prefix, requiredClass);
        }
    }

    private static void forItems(OrePrefix prefix, Class<?> requiredClass) {
        List stacks = OreDictUnifier.getAll((UnificationEntry)new UnificationEntry(prefix, material));
        stacks.stream().filter(stack -> requiredClass.isInstance(stack.func_77973_b())).forEach(action);
    }

    public static void forMaterialFluid(Material material, Consumer<Fluid> action) {
        if (!material.hasFluid()) {
            return;
        }
        FluidStorageKeyAccessor.getKeys().values().forEach(key -> {
            Fluid fluid = material.getFluid(key);
            if (fluid != null) {
                action.accept(fluid);
            }
        });
    }
}

