/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.groovy;

import com.nomiceu.nomilabs.util.ItemMeta;
import com.nomiceu.nomilabs.util.LabsTranslate;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NBTClearingRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public static final Map<ItemMeta, Map<ItemMeta, LabsTranslate.Translatable>> NBT_CLEARERS = new Object2ObjectOpenHashMap();
    public static final LabsTranslate.Translatable WARNING_TOOLTIP = new LabsTranslate.Translatable("tooltip.nomilabs.recipe.clearing", new Object[0]);
    public static final LabsTranslate.Translatable CAN_CLEAR_TOOLTIP = new LabsTranslate.Translatable("tooltip.nomilabs.item.can_clear", new Object[0]);
    private final ItemMeta singleInput;
    private final ItemMeta exampleOutput;
    @Nullable
    private final Consumer<ItemStack> nbtClearer;

    public NBTClearingRecipe(ItemStack input, ItemStack exampleOutput, @Nullable Consumer<ItemStack> nbtClearer) {
        this.singleInput = new ItemMeta(input);
        this.exampleOutput = new ItemMeta(exampleOutput);
        this.nbtClearer = nbtClearer;
    }

    public boolean func_77569_a(@NotNull InventoryCrafting inv, @NotNull World worldIn) {
        boolean found = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (found || !this.singleInput.compareWith(inv.func_70301_a(i))) {
                return false;
            }
            found = true;
        }
        return found;
    }

    @NotNull
    public ItemStack func_77572_b(@NotNull InventoryCrafting inv) {
        if (this.nbtClearer == null) {
            return this.exampleOutput.toStack();
        }
        ItemStack stack = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_() && (stack = inv.func_70301_a(i)).func_190926_b(); ++i) {
        }
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack display = this.exampleOutput.toStack();
        NBTTagCompound origTag = stack.func_77978_p();
        if (origTag != null) {
            display.func_77982_d(origTag.func_74737_b());
        }
        this.nbtClearer.accept(display);
        return display;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack func_77571_b() {
        return this.exampleOutput.toStack();
    }

    @NotNull
    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        return NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }
}

