/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.groovy;

import com.cleanroommc.groovyscript.api.GroovyLog;
import com.nomiceu.nomilabs.integration.nuclearcraft.AccessibleCoolerType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nc.config.NCConfig;
import nc.enumm.MetaEnums;
import nc.recipe.IRecipe;
import nc.recipe.NCRecipes;
import nc.recipe.ProcessorRecipe;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.other.ActiveCoolerRecipes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;

public class NCActiveCoolerHelper {
    private static boolean loadedFluidNames = false;
    private static final List<String> fluidNamesFromIDs = new ArrayList<String>();

    public static List<String> getFluidNamesFromIDs() {
        if (!loadedFluidNames) {
            NCActiveCoolerHelper.reloadFluidNames();
        }
        loadedFluidNames = true;
        return fluidNamesFromIDs;
    }

    private static void reloadFluidNames() {
        fluidNamesFromIDs.clear();
        for (int i = 1; i < MetaEnums.CoolerType.values().length; ++i) {
            fluidNamesFromIDs.add(i - 1, ((AccessibleCoolerType)MetaEnums.CoolerType.values()[i]).getOriginalFluidName());
        }
    }

    public static void onReload() {
        if (NCRecipes.active_cooler == null) {
            return;
        }
        NCActiveCoolerHelper.reloadFluidNames();
        NCRecipes.active_cooler.removeAllRecipes();
        NCRecipes.active_cooler.addRecipes();
    }

    public static void afterScriptLoad() {
        if (NCRecipes.active_cooler == null) {
            return;
        }
        NCRecipes.active_cooler.refreshCache();
    }

    @Optional.Method(modid="nuclearcraft")
    public static void changeCoolerRecipe(FluidStack newStack, MetaEnums.CoolerType type) {
        if (NCRecipes.active_cooler == null) {
            GroovyLog.get().error((Object)"Active Cooler Recipes not Found!");
            return;
        }
        boolean removed = false;
        for (ProcessorRecipe recipe : NCRecipes.active_cooler.getRecipeList()) {
            IFluidIngredient ing;
            if (recipe.fluidIngredients().size() != 1 || (ing = (IFluidIngredient)recipe.fluidIngredients().get(0)).getInputStackList().size() != 1 || !Objects.equals(((FluidStack)ing.getInputStackList().get(0)).getFluid().getName(), type.getFluidName())) continue;
            NCRecipes.active_cooler.removeRecipe((IRecipe)recipe);
            removed = true;
            break;
        }
        if (!removed) {
            GroovyLog.get().error((Object)("Could not find ActiveCooler recipe for " + type.getFluidName() + "!"));
        }
        NCRecipes.active_cooler.addRecipe(new Object[]{ActiveCoolerRecipes.fluidStack((String)newStack.getFluid().getName(), (int)NCConfig.active_cooler_max_rate), Math.round(NCConfig.fission_active_cooling_rate[type.getID() - 1] * (double)NCConfig.active_cooler_max_rate / 20.0), Math.round(NCConfig.fusion_active_cooling_rate[type.getID() - 1] * (double)NCConfig.active_cooler_max_rate / 20.0)});
        NCActiveCoolerHelper.getFluidNamesFromIDs().set(type.getID() - 1, newStack.getFluid().getName());
    }
}

