/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.groovy;

import com.cleanroommc.groovyscript.api.IIngredient;
import com.nomiceu.nomilabs.groovy.GroovyHelpers;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class RecipePredicates {
    public static Predicate<Recipe> hasExactlyInput(IIngredient ... items) {
        return recipe -> RecipePredicates.hasExactlyInputs(recipe.getInputs(), items);
    }

    public static Predicate<Recipe> hasInput(IIngredient ... items) {
        return recipe -> RecipePredicates.hasInputs(recipe.getInputs(), items);
    }

    public static Predicate<Recipe> hasExactlyFluidInput(IIngredient ... fluids) {
        return recipe -> RecipePredicates.hasExactlyInputs(recipe.getFluidInputs(), fluids);
    }

    public static Predicate<Recipe> hasFluidInput(IIngredient ... items) {
        return recipe -> RecipePredicates.hasInputs(recipe.getFluidInputs(), items);
    }

    private static boolean hasInputs(List<GTRecipeInput> inputs, IIngredient[] items) {
        List gtItems = Arrays.stream(items).map(GroovyHelpers.GTRecipeHelpers::toGtInput).collect(Collectors.toList());
        return new HashSet<GTRecipeInput>(inputs).containsAll(gtItems);
    }

    private static boolean hasExactlyInputs(List<GTRecipeInput> inputs, IIngredient[] items) {
        if (inputs.size() != items.length) {
            return false;
        }
        List gtItems = Arrays.stream(items).map(GroovyHelpers.GTRecipeHelpers::toGtInput).collect(Collectors.toList());
        return new HashSet<GTRecipeInput>(inputs).containsAll(gtItems);
    }
}

