/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.groovy;

import com.cleanroommc.groovyscript.api.GroovyBlacklist;
import com.cleanroommc.groovyscript.api.IIngredient;
import com.cleanroommc.groovyscript.compat.vanilla.VanillaModule;
import com.cleanroommc.groovyscript.helper.ingredient.OreDictIngredient;
import com.cleanroommc.groovyscript.registry.ReloadableRegistryManager;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.nomiceu.nomilabs.NomiLabs;
import com.nomiceu.nomilabs.gregtech.mixinhelper.AccessibleRecipeMap;
import com.nomiceu.nomilabs.groovy.LabsVirtualizedRegistries;
import com.nomiceu.nomilabs.groovy.PartialRecipe;
import com.nomiceu.nomilabs.util.ItemMeta;
import com.nomiceu.nomilabs.util.ItemTagMeta;
import com.nomiceu.nomilabs.util.LabsGroovyHelper;
import com.nomiceu.nomilabs.util.LabsNames;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.RecyclingHandler;
import gregtech.api.recipes.category.GTRecipeCategory;
import gregtech.api.recipes.category.RecipeCategories;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.ingredients.GTRecipeItemInput;
import gregtech.api.recipes.ingredients.GTRecipeOreInput;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.stack.ItemMaterialInfo;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.loaders.recipe.RecyclingRecipes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@GroovyBlacklist
public class RecyclingHelper {
    private static boolean reloadingRecycling = false;
    public static final Map<RecipeMap<?>, GTRecipeCategory> recyclingMaps = ImmutableMap.of((Object)RecipeMaps.ARC_FURNACE_RECIPES, (Object)RecipeCategories.ARC_FURNACE_RECYCLING, (Object)RecipeMaps.MACERATOR_RECIPES, (Object)RecipeCategories.MACERATOR_RECYCLING, (Object)RecipeMaps.EXTRACTOR_RECIPES, (Object)RecipeCategories.EXTRACTOR_RECYCLING);

    public static void reloadRecyclingRecipes() {
        if (LabsVirtualizedRegistries.REPLACE_RECYCLING_MANAGER.needReloading.isEmpty()) {
            return;
        }
        reloadingRecycling = true;
        long time = System.currentTimeMillis();
        for (Map.Entry<ItemMeta, ItemMaterialInfo> modified : LabsVirtualizedRegistries.REPLACE_RECYCLING_MANAGER.needReloading.entrySet()) {
            ItemMeta itemMeta = modified.getKey();
            ItemStack stack = itemMeta.toStack();
            NomiLabs.LOGGER.debug("Removing Recycling Recipes for {} @ {}...", (Object)itemMeta.getItem().getRegistryName(), (Object)itemMeta.getMeta());
            RecyclingHelper.removeRecyclingRecipe(RecipeMaps.ARC_FURNACE_RECIPES, RecipeCategories.ARC_FURNACE_RECYCLING, stack, Materials.Oxygen.getFluid());
            RecyclingHelper.removeRecyclingRecipe(RecipeMaps.MACERATOR_RECIPES, RecipeCategories.MACERATOR_RECYCLING, stack, null);
            RecyclingHelper.removeRecyclingRecipe(RecipeMaps.EXTRACTOR_RECIPES, RecipeCategories.EXTRACTOR_RECYCLING, stack, null);
            if (modified.getValue() == null) continue;
            NomiLabs.LOGGER.debug("Adding Recycling Recipes for {} @ {}...", (Object)itemMeta.getItem().getRegistryName(), (Object)itemMeta.getMeta());
            RecyclingRecipes.registerRecyclingRecipes((ItemStack)stack, (List)modified.getValue().getMaterials(), (boolean)false, null);
        }
        NomiLabs.LOGGER.info("Reloading Recycling Recipes took {}ms", (Object)(System.currentTimeMillis() - time));
        reloadingRecycling = false;
    }

    private static void removeRecyclingRecipe(RecipeMap<?> map, GTRecipeCategory category, ItemStack itemInput, Fluid fluidInput) {
        Recipe recipe = map.find(Collections.singletonList(itemInput), fluidInput == null ? Collections.emptyList() : Collections.singletonList(new FluidStack(fluidInput, 1)), recipe1 -> recipe1.getRecipeCategory().equals((Object)category));
        if (recipe == null) {
            return;
        }
        NomiLabs.LOGGER.debug("Removing Recycling Recipe for {} @ {} in recipe map {} and recipe category {}.", (Object)itemInput.func_77973_b().getRegistryName(), (Object)itemInput.func_77960_j(), (Object)map.getUnlocalizedName(), (Object)category.getName());
        map.removeRecipe(recipe);
    }

    public static void replaceRecipeShaped(ResourceLocation name, ItemStack output, List<List<IIngredient>> inputs) {
        RecyclingHelper.validate(name, output, true, false);
        VanillaModule.crafting.remove(name);
        VanillaModule.crafting.addShaped(LabsNames.makeGroovyName(name.func_110623_a()), output, inputs);
        RecyclingHelper.registerRecycling(output, inputs);
    }

    public static void replaceRecipeShaped(ItemStack oldOutput, ItemStack newOutput, List<List<IIngredient>> inputs) {
        RecyclingHelper.replaceRecipeShaped(RecyclingHelper.getRecipeName(oldOutput), newOutput, inputs);
    }

    public static void replaceRecipeOutput(ResourceLocation name, ItemStack newOutput) {
        IShapedRecipe originalRecipe = RecyclingHelper.validate(name, newOutput, true, true);
        int originalCount = originalRecipe.func_77571_b().func_190916_E();
        int newCount = newOutput.func_190916_E();
        VanillaModule.crafting.remove(name);
        ReloadableRegistryManager.addRegistryEntry((IForgeRegistry)ForgeRegistries.RECIPES, (ResourceLocation)LabsNames.makeGroovyName(name.func_110623_a()), (IForgeRegistryEntry)new PartialRecipe(originalRecipe, newOutput.func_77946_l()));
        ImmutableList originalMaterials = Objects.requireNonNull(OreDictUnifier.getMaterialInfo((ItemStack)newOutput)).getMaterials();
        ArrayList newMaterials = new ArrayList();
        originalMaterials.forEach(materialStack -> newMaterials.add(new MaterialStack(materialStack.material, materialStack.amount * (long)originalCount / (long)newCount)));
        LabsVirtualizedRegistries.REPLACE_RECYCLING_MANAGER.registerOre(newOutput, new ItemMaterialInfo(newMaterials));
    }

    public static void replaceRecipeOutput(ItemStack oldOutput, ItemStack newOutput) {
        RecyclingHelper.replaceRecipeOutput(RecyclingHelper.getRecipeName(oldOutput), newOutput);
    }

    public static void replaceRecipeInput(ResourceLocation name, List<List<IIngredient>> newInputs) {
        IShapedRecipe originalRecipe = RecyclingHelper.validate(name, ItemStack.field_190927_a, false, false);
        ItemStack originalOutput = originalRecipe.func_77571_b();
        VanillaModule.crafting.remove(name);
        VanillaModule.crafting.addShaped(LabsNames.makeGroovyName(name.func_110623_a()), originalOutput, newInputs);
        RecyclingHelper.registerRecycling(originalOutput, newInputs);
    }

    public static void replaceRecipeInput(ItemStack oldOutput, List<List<IIngredient>> newInputs) {
        RecyclingHelper.replaceRecipeInput(RecyclingHelper.getRecipeName(oldOutput), newInputs);
    }

    public static void createRecipe(String name, ItemStack output, List<List<IIngredient>> input) {
        VanillaModule.crafting.addShaped(LabsNames.makeGroovyName(name), output, input);
        RecyclingHelper.registerRecycling(output, input);
    }

    public static void createRecipe(ItemStack output, List<List<IIngredient>> input) {
        VanillaModule.crafting.addShaped(output, input);
        RecyclingHelper.registerRecycling(output, input);
    }

    public static void changeStackRecycling(ItemStack output, List<IIngredient> ingredients) {
        RecyclingHelper.registerRecycling(output, Collections.singletonList(ingredients));
    }

    public static boolean changeStackRecycling(List<ItemStack> outputs, List<GTRecipeInput> inputs) {
        if (outputs.size() != 1 || inputs.isEmpty()) {
            LabsGroovyHelper.throwOrGroovyLog(new IllegalArgumentException("Cannot change recycling from recipe when there is not one item output, or there are no item inputs!"));
            return false;
        }
        LabsVirtualizedRegistries.REPLACE_RECYCLING_MANAGER.registerOre(outputs.get(0), RecyclingHandler.getRecyclingIngredients(inputs, (int)outputs.get(0).func_190916_E()));
        return true;
    }

    public static boolean changeStackRecycling(ItemStack output, RecipeMap<?> map, Predicate<Recipe> acceptedRecipe) {
        List<Recipe> foundRecipes = ((AccessibleRecipeMap)map).findByOutput(Collections.singletonList(output), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), acceptedRecipe);
        if (foundRecipes == null || foundRecipes.isEmpty()) {
            LabsGroovyHelper.throwOrGroovyLog(new IllegalStateException("Could not find recipe in Recipe Map " + map.getUnlocalizedName() + " with output " + output.toString() + "!"));
            return false;
        }
        if (foundRecipes.size() > 1) {
            HashMultiset inputs = HashMultiset.create();
            inputs.addAll((Collection)foundRecipes.get(0).getInputs());
            boolean inputsAllEqual = true;
            for (int i = 1; i < foundRecipes.size(); ++i) {
                HashMultiset compare = HashMultiset.create();
                compare.addAll((Collection)foundRecipes.get(i).getInputs());
                if (inputs.equals((Object)compare)) continue;
                inputsAllEqual = false;
                break;
            }
            if (!inputsAllEqual) {
                LabsGroovyHelper.throwOrGroovyLog(new IllegalStateException("Found more than one recipe in Recipe Map " + map.getUnlocalizedName() + " with output " + output.toString() + "!"));
                return false;
            }
        }
        return RecyclingHelper.changeStackRecycling((List<ItemStack>)foundRecipes.get(0).getOutputs(), foundRecipes.get(0).getInputs());
    }

    private static IShapedRecipe validate(ResourceLocation name, ItemStack output, boolean validateOutput, boolean requireOutputOriginalInfo) {
        IRecipe originalRecipe = (IRecipe)ForgeRegistries.RECIPES.getValue(name);
        if (originalRecipe == null) {
            throw new IllegalArgumentException("Could not find recipe with name " + name + "!");
        }
        if (!(originalRecipe instanceof IShapedRecipe)) {
            throw new IllegalArgumentException("Recipe with name " + name + " is not shaped!");
        }
        IShapedRecipe shapedRecipe = (IShapedRecipe)originalRecipe;
        if (originalRecipe.func_192399_d()) {
            throw new IllegalArgumentException("Cannot replace Dynamic Recipe " + name + "!");
        }
        ItemStack originalOutput = RecyclingHelper.checkAndGetOutput(output, validateOutput, originalRecipe);
        if (requireOutputOriginalInfo && OreDictUnifier.getMaterialInfo((ItemStack)originalOutput) == null) {
            throw new IllegalArgumentException("Could not find existing Material Info for item " + originalOutput);
        }
        ReloadableRegistryManager.removeRegistryEntry((IForgeRegistry)ForgeRegistries.RECIPES, (ResourceLocation)name);
        return shapedRecipe;
    }

    private static boolean isRecipeValid(ResourceLocation name) {
        IRecipe originalRecipe = (IRecipe)ForgeRegistries.RECIPES.getValue(name);
        if (originalRecipe == null) {
            return false;
        }
        if (!(originalRecipe instanceof IShapedRecipe)) {
            return false;
        }
        return !originalRecipe.func_192399_d();
    }

    private static void registerRecycling(ItemStack output, List<List<IIngredient>> inputs) {
        if (inputs.isEmpty() || inputs.stream().allMatch(List::isEmpty)) {
            LabsVirtualizedRegistries.REPLACE_RECYCLING_MANAGER.registerOre(output, null);
            return;
        }
        ArrayList<GTRecipeInput> gtInputs = new ArrayList<GTRecipeInput>();
        for (List<IIngredient> inputList : inputs) {
            for (IIngredient input : inputList) {
                GTRecipeInput gtInput = RecyclingHelper.ofGroovyIngredient(input);
                if (gtInput == null) continue;
                gtInputs.add(gtInput);
            }
        }
        LabsVirtualizedRegistries.REPLACE_RECYCLING_MANAGER.registerOre(output, RecyclingHandler.getRecyclingIngredients(gtInputs, (int)output.func_190916_E()));
    }

    @NotNull
    private static ItemStack checkAndGetOutput(ItemStack output, boolean validateOutput, IRecipe originalRecipe) {
        ItemStack originalOutput = originalRecipe.func_77571_b();
        if (validateOutput) {
            if (!Objects.equals(originalOutput.func_77973_b().getRegistryName(), output.func_77973_b().getRegistryName())) {
                throw new IllegalArgumentException("New Recipe Output " + output.func_77973_b().getRegistryName() + " must have same Registry Name as Original Input " + originalOutput.func_77973_b().getRegistryName() + "!");
            }
            if (originalOutput.func_77960_j() != output.func_77960_j()) {
                throw new IllegalArgumentException("New Recipe Output's Metadata " + output.func_77960_j() + " must be the same as Original Input's Metadata " + originalOutput.func_77960_j() + "!");
            }
        }
        return originalOutput;
    }

    @Nullable
    private static GTRecipeInput ofGroovyIngredient(IIngredient ingredient) {
        if (ingredient instanceof OreDictIngredient) {
            OreDictIngredient oreDictIngredient = (OreDictIngredient)ingredient;
            return new GTRecipeOreInput(oreDictIngredient.getOreDict(), ingredient.getAmount());
        }
        IIngredient iIngredient = ingredient;
        if (iIngredient instanceof ItemStack) {
            ItemStack stack = (ItemStack)iIngredient;
            return new GTRecipeItemInput(stack);
        }
        return null;
    }

    private static ResourceLocation getRecipeName(ItemStack oldOutput) {
        ResourceLocation name = null;
        for (IRecipe recipe : ForgeRegistries.RECIPES) {
            if (recipe.getRegistryName() == null || !RecyclingHelper.isRecipeValid(recipe.getRegistryName()) || !ItemTagMeta.compare(recipe.func_77571_b(), oldOutput) || recipe.func_77571_b().func_190916_E() != oldOutput.func_190916_E()) continue;
            if (name == null) {
                name = recipe.getRegistryName();
                continue;
            }
            throw new IllegalArgumentException("Error Finding Recipes for Output " + oldOutput + ":Too Many Recipes for Output. Max: 1.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Error Finding Recipes for Output " + oldOutput + ":No recipes for Output. Requires: 1. Recipes must not be dynamic, and have the exact same stack, including count, metadata and tag.");
        }
        return name;
    }

    public static boolean isReloadingRecycling() {
        return reloadingRecycling;
    }
}

