/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.groovy;

import com.cleanroommc.groovyscript.api.GroovyLog;
import com.cleanroommc.groovyscript.api.IIngredient;
import com.cleanroommc.groovyscript.compat.vanilla.ShapedCraftingRecipe;
import com.cleanroommc.groovyscript.helper.ingredient.IngredientHelper;
import groovy.lang.Closure;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShapedConversionRecipe
extends ShapedCraftingRecipe {
    private int recipeInputLocation = -1;
    private int trueInputLocation;
    private Integer[] cache;

    public ShapedConversionRecipe(ItemStack output, List<IIngredient> input, int width, int height) {
        this(output, input, width, height, false, null, null);
    }

    public ShapedConversionRecipe(ItemStack output, List<IIngredient> input, int width, int height, boolean mirrored, @Nullable Closure<ItemStack> recipeFunction, @Nullable Closure<Void> recipeAction) {
        super(output, input, width, height, mirrored, recipeFunction, recipeAction);
        if (width != height) {
            GroovyLog.get().exception((Throwable)new IllegalArgumentException("Shaped Conversion Recipes must have the same width and height!"));
            return;
        }
        for (int i = 0; i < input.size(); ++i) {
            IIngredient ing = input.get(i);
            if (IngredientHelper.isEmpty((IIngredient)ing)) continue;
            if (this.recipeInputLocation != -1) {
                GroovyLog.get().exception((Throwable)new IllegalArgumentException("Shaped Conversion Recipes can only have one non-empty input!"));
                return;
            }
            this.recipeInputLocation = i;
        }
        this.trueInputLocation = this.recipeInputLocation;
        if (width == 1) {
            this.recipeInputLocation = 4;
        } else if (width == 2 && this.recipeInputLocation > 1) {
            ++this.recipeInputLocation;
        }
    }

    public boolean func_77569_a(@NotNull InventoryCrafting inv, @NotNull World worldIn) {
        return ShapedConversionRecipe.matchesShaped(inv, this.recipeInputLocation, stack -> ((IIngredient)this.input.get(this.trueInputLocation)).test(stack), this.cache, cache1 -> {
            this.cache = cache1;
        });
    }

    public static boolean matchesShaped(@NotNull InventoryCrafting inv, int inputLocation, Predicate<ItemStack> accepts, Integer[] cache, Consumer<Integer[]> setCache) {
        if (inv.func_174922_i() < 2 || inv.func_174922_i() > 3 || inv.func_174923_h() < 2 || inv.func_174923_h() > 3 || inv.func_174922_i() != inv.func_174923_h()) {
            return false;
        }
        if (inputLocation == -1) {
            return false;
        }
        int location = ShapedConversionRecipe.getLocationForDim(inv.func_174922_i(), inputLocation, cache, setCache);
        if (location == -1) {
            return false;
        }
        int locationX = location % inv.func_174922_i();
        int locationY = location / inv.func_174922_i();
        for (int x = 0; x < inv.func_174922_i(); ++x) {
            for (int y = 0; y < inv.func_174923_h(); ++y) {
                if (!(x == locationX && y == locationY ? !accepts.test(inv.func_70463_b(x, y)) : !inv.func_70463_b(x, y).func_190926_b())) continue;
                return false;
            }
        }
        return true;
    }

    private static int getLocationForDim(int dim, int inputLocation, Integer[] cache, Consumer<Integer[]> setCache) {
        if (cache == null) {
            cache = new Integer[2];
            cache[0] = inputLocation;
            if (inputLocation > 4 || inputLocation == 2) {
                cache[0] = -1;
            } else if (inputLocation > 2) {
                cache[0] = inputLocation - 1;
            }
            cache[1] = inputLocation;
            setCache.accept(cache);
        }
        return cache[dim - 2];
    }
}

