/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.integration.ae2;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.fluids.util.AEFluidInventory;
import appeng.fluids.util.AEFluidStack;
import appeng.fluids.util.IAEFluidInventory;
import appeng.fluids.util.IAEFluidTank;
import com.nomiceu.nomilabs.integration.ae2.NotifiableFluidInventory;
import java.util.function.Supplier;
import net.minecraftforge.fluids.FluidStack;

public class LabsImplNetworkFluidInventory
extends AEFluidInventory {
    private final Supplier<IStorageGrid> supplier;
    private final IActionSource source;
    private final NotifiableFluidInventory handler;

    public LabsImplNetworkFluidInventory(Supplier<IStorageGrid> networkSupplier, IActionSource source, IAEFluidInventory handler, int slots, int capcity) {
        super(handler, slots, capcity);
        this.supplier = networkSupplier;
        this.source = source;
        this.handler = (NotifiableFluidInventory)handler;
    }

    public int fill(FluidStack fluid, boolean doFill) {
        if (fluid == null || fluid.amount <= 0) {
            return 0;
        }
        IStorageGrid storage = this.supplier.get();
        if (storage != null) {
            int originAmt = fluid.amount;
            IMEMonitor dest = storage.getInventory(AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class));
            IAEFluidStack overflow = (IAEFluidStack)dest.injectItems((IAEStack)AEFluidStack.fromFluidStack((FluidStack)fluid), doFill ? Actionable.MODULATE : Actionable.SIMULATE, this.source);
            if (overflow != null && overflow.getStackSize() == (long)originAmt) {
                return super.fill(fluid, doFill);
            }
            if (overflow != null) {
                if (doFill) {
                    FluidStack added = fluid.copy();
                    added.amount = (int)((long)fluid.amount - overflow.getStackSize());
                    this.handler.labs$onFluidInventoryChanged((IAEFluidTank)this, added, null);
                }
                return (int)((long)originAmt - overflow.getStackSize());
            }
            if (doFill) {
                this.handler.labs$onFluidInventoryChanged((IAEFluidTank)this, fluid, null);
            }
            return originAmt;
        }
        return super.fill(fluid, doFill);
    }
}

