/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.integration.betterp2p;

import com.nomiceu.nomilabs.integration.betterp2p.AccessibleInfoWrapper;
import com.projecturanus.betterp2p.client.gui.Filter;
import com.projecturanus.betterp2p.client.gui.InfoWrapper;
import java.util.List;
import kotlin.jvm.functions.Function2;
import kotlin.text.Regex;
import net.minecraftforge.common.util.EnumHelper;

public class LabsFilters {
    public static final Filter DISTANCE_LESS = LabsFilters.addFilter("DISTANCE_LESS", new Regex("\\A@distless=((\\d+(\\.\\d*)?)|(\\.\\d+))m?\\z"), (Function2<InfoWrapper, List<String>, Boolean>)((Function2)(info, args) -> {
        double distance = Double.MAX_VALUE;
        for (String arg : args) {
            distance = Math.min(Double.parseDouble(arg), distance);
        }
        return ((AccessibleInfoWrapper)info).labs$getDistance() <= distance;
    }));
    public static final Filter DISTANCE_MORE = LabsFilters.addFilter("DISTANCE_MORE", new Regex("\\A@distmore=((\\d+(\\.\\d*)?)|(\\.\\d+))m?\\z"), (Function2<InfoWrapper, List<String>, Boolean>)((Function2)(info, args) -> {
        double distance = 0.0;
        for (String arg : args) {
            distance = Math.max(Double.parseDouble(arg), distance);
        }
        return ((AccessibleInfoWrapper)info).labs$getDistance() >= distance;
    }));

    public static void postInit() {
    }

    private static Filter addFilter(String name, Regex regex, Function2<InfoWrapper, List<String>, Boolean> filter) {
        return (Filter)EnumHelper.addEnum(Filter.class, (String)name, (Class[])new Class[]{Regex.class, Function2.class}, (Object[])new Object[]{regex, filter});
    }
}

