/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.integration.betterp2p;

import com.nomiceu.nomilabs.integration.betterp2p.AccessibleInfoWrapper;
import com.nomiceu.nomilabs.util.LabsTranslate;
import com.projecturanus.betterp2p.client.gui.InfoWrapper;
import java.util.Comparator;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public enum SortModes {
    DEFAULT("nomilabs.gui.advanced_memory_card.sort.default", SortModes::compDefault),
    DISTANCE("nomilabs.gui.advanced_memory_card.sort.distance", SortModes.wrapComp(SortModes::compareDistThenName)),
    NAME("nomilabs.gui.advanced_memory_card.sort.name", SortModes.wrapComp((a, b) -> {
        if (a.getName().equals(b.getName())) {
            return SortModes.compareTypeThenDist(a, b, false);
        }
        return StringUtils.compareIgnoreCase((String)a.getName(), (String)b.getName());
    }));

    private final String translationKey;
    private final Function<InfoWrapper, Comparator<InfoWrapper>> compFromSelected;

    private SortModes(String key, Function<InfoWrapper, Comparator<InfoWrapper>> compFromSelected) {
        this.translationKey = key;
        this.compFromSelected = compFromSelected;
    }

    public String getName() {
        return LabsTranslate.translate(this.translationKey, new Object[0]);
    }

    public Comparator<InfoWrapper> getComp(InfoWrapper selected) {
        Comparator<InfoWrapper> applyComp = this.compFromSelected.apply(selected);
        return (a, b) -> {
            if (selected != null) {
                if (a.getLoc().equals((Object)selected.getLoc())) {
                    return -1;
                }
                if (b.getLoc().equals((Object)selected.getLoc())) {
                    return 1;
                }
            }
            return applyComp.compare((InfoWrapper)a, (InfoWrapper)b);
        };
    }

    private static Function<InfoWrapper, Comparator<InfoWrapper>> wrapComp(Comparator<InfoWrapper> comp) {
        return a -> comp;
    }

    private static Comparator<InfoWrapper> compDefault(InfoWrapper selected) {
        return (a, b) -> {
            if (selected != null) {
                if (a.getFrequency() == selected.getFrequency()) {
                    if (b.getFrequency() != selected.getFrequency()) {
                        return -1;
                    }
                    return SortModes.compareTypeThenDist(a, b, true);
                }
                if (b.getFrequency() == selected.getFrequency()) {
                    return 1;
                }
            }
            if (a.getFrequency() != b.getFrequency()) {
                if (a.getFrequency() == 0) {
                    return -1;
                }
                if (b.getFrequency() == 0) {
                    return 1;
                }
                if (a.getError()) {
                    if (b.getError()) {
                        return StringUtils.compareIgnoreCase((String)a.getFreqDisplay(), (String)b.getFreqDisplay());
                    }
                    return -1;
                }
                if (b.getError()) {
                    return 1;
                }
                return StringUtils.compareIgnoreCase((String)a.getFreqDisplay(), (String)b.getFreqDisplay());
            }
            return SortModes.compareTypeThenDist(a, b, true);
        };
    }

    private static int compareTypeThenDist(InfoWrapper a, InfoWrapper b, boolean compareNameBackup) {
        if (a.getOutput() != b.getOutput()) {
            return a.getOutput() ? 1 : -1;
        }
        if (!compareNameBackup) {
            return SortModes.compareDistance(a, b);
        }
        return SortModes.compareDistThenName(a, b);
    }

    private static int compareDistThenName(InfoWrapper a, InfoWrapper b) {
        int compDist = SortModes.compareDistance(a, b);
        if (compDist == 0) {
            return StringUtils.compareIgnoreCase((String)a.getName(), (String)b.getName());
        }
        return compDist;
    }

    private static int compareDistance(InfoWrapper a, InfoWrapper b) {
        if (SortModes.getAccess(a).labs$isDifferentDim()) {
            if (SortModes.getAccess(b).labs$isDifferentDim()) {
                return Integer.compare(a.getLoc().getDim(), b.getLoc().getDim());
            }
            return 1;
        }
        if (SortModes.getAccess(b).labs$isDifferentDim()) {
            return -1;
        }
        return Double.compare(SortModes.getAccess(a).labs$getDistance(), SortModes.getAccess(b).labs$getDistance());
    }

    private static AccessibleInfoWrapper getAccess(InfoWrapper info) {
        return (AccessibleInfoWrapper)info;
    }
}

