/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.integration.betterquesting;

import com.google.common.collect.ImmutableList;
import com.nomiceu.nomilabs.integration.betterquesting.InteractiveState;
import com.nomiceu.nomilabs.integration.betterquesting.PanelDescription;
import com.nomiceu.nomilabs.integration.betterquesting.RenderDescriptionPart;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.gui.FontRenderer;
import org.apache.commons.lang3.StringUtils;

public abstract class DescriptionPart {
    public static final Pattern SPECIAL_MATCH = Pattern.compile("<\\{(link|copy)}>(.+?)(?:<\\|>(.+?))?(?:<\\|>(disabled))?<\\{\\1}>");

    public abstract DescriptionPart allAfter(int var1);

    public abstract RenderDescriptionPart toRender(int var1, int var2);

    public abstract RenderDescriptionPart toRender(int var1, int var2, int var3);

    public abstract String toRenderText();

    public static boolean textContainsCustom(String text) {
        return SPECIAL_MATCH.matcher(text).find();
    }

    public static List<DescriptionPart> splitString(String text) {
        ObjectArrayList parts = new ObjectArrayList();
        Matcher matcher = SPECIAL_MATCH.matcher(text);
        int lastHandled = 0;
        String currFormat = "";
        while (matcher.find()) {
            String normalText = currFormat + text.substring(lastHandled, matcher.start());
            parts.add(new DescriptionText(normalText));
            parts.add(new DescriptionInteractive(matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4) != null));
            lastHandled = matcher.end();
            currFormat = FontRenderer.func_78282_e((String)normalText);
        }
        String remainingText = text.substring(lastHandled);
        if (!remainingText.isEmpty()) {
            parts.add(new DescriptionText(currFormat + remainingText));
        }
        return ImmutableList.copyOf((Collection)parts);
    }

    public static class DescriptionText
    extends DescriptionPart {
        protected final String text;

        public DescriptionText(String text) {
            this.text = text;
        }

        @Override
        public DescriptionPart allAfter(int startIndex) {
            String sub = this.text.substring(startIndex);
            sub = FontRenderer.func_78282_e((String)this.text.substring(0, startIndex)) + sub;
            return new DescriptionText(sub);
        }

        @Override
        public RenderDescriptionPart toRender(int x, int y) {
            return this.toRender(x, y, this.text.length());
        }

        @Override
        public RenderDescriptionPart toRender(int x, int y, int end) {
            String sub = StringUtils.stripEnd((String)this.text.substring(0, end), (String)"\n\r");
            return new RenderDescriptionPart.RenderDescriptionText(sub, PanelDescription.fontRenderer().func_78256_a(sub), x, y);
        }

        @Override
        public String toRenderText() {
            return this.text;
        }
    }

    public static class DescriptionInteractive
    extends DescriptionPart {
        protected final String type;
        protected final String display;
        protected final String content;
        protected final InteractiveState state;

        public DescriptionInteractive(String type, String content, String display, boolean disabled) {
            this.type = type;
            this.content = content;
            this.state = CustomType.valueOf((String)type.toUpperCase()).toState.toState(content, disabled);
            this.display = display == null ? this.state.format() + content : this.state.format() + display;
        }

        private DescriptionInteractive(String type, String content, String display, InteractiveState state) {
            this.type = type;
            this.content = content;
            this.display = state.format() + display;
            this.state = state;
        }

        public InteractiveState getState() {
            return this.state;
        }

        @Override
        public DescriptionPart allAfter(int startIndex) {
            return new DescriptionInteractive(this.type, this.content, this.display.substring(startIndex), this.state);
        }

        @Override
        public RenderDescriptionPart toRender(int x, int y) {
            return this.toRender(x, y, this.display.length());
        }

        @Override
        public RenderDescriptionPart toRender(int x, int y, int end) {
            String sub = StringUtils.stripEnd((String)this.display.substring(0, end), (String)"\n\r");
            return new RenderDescriptionPart.RenderDescriptionInteractive(sub, PanelDescription.fontRenderer().func_78256_a(sub), x, y, this.state);
        }

        @Override
        public String toRenderText() {
            return this.display;
        }
    }

    @FunctionalInterface
    public static interface TypeToState {
        public InteractiveState toState(String var1, boolean var2);
    }

    public static enum CustomType {
        LINK(InteractiveState.InteractiveLink::new),
        COPY(InteractiveState.InteractiveCopy::new);

        public final TypeToState toState;

        private CustomType(TypeToState toState) {
            this.toState = toState;
        }
    }
}

