/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.integration.betterquesting;

import betterquesting.api2.client.gui.controls.IValueIO;
import betterquesting.api2.client.gui.controls.io.ValueFuncIO;
import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import betterquesting.api2.client.gui.resources.colors.GuiColorTransition;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import com.google.common.collect.ImmutableList;
import com.nomiceu.nomilabs.integration.betterquesting.RenderDescriptionPart;
import com.nomiceu.nomilabs.mixinhelper.GuiCustomConfirmOpenLink;
import com.nomiceu.nomilabs.util.LabsTranslate;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.TextFormatting;

public abstract class InteractiveState {
    protected final List<RenderDescriptionPart.RenderDescriptionInteractive> parts = new ObjectArrayList();

    public void addPart(RenderDescriptionPart.RenderDescriptionInteractive part) {
        this.parts.add(part);
    }

    public void clearParts() {
        this.parts.clear();
    }

    public abstract String format();

    public abstract GuiColorTransition color();

    public abstract List<String> tooltip(boolean var1);

    public abstract void handleMouseOver(boolean var1);

    public abstract void handleMouseClick(GuiScreen var1);

    public static class InteractiveLink
    extends InteractiveCopy {
        public static final GuiColorStatic DEFAULT_COLOR = new GuiColorStatic(8900331);

        public InteractiveLink(String toCopy, boolean disabled) {
            super(toCopy, disabled, (IGuiColor)DEFAULT_COLOR, (IGuiColor)OVER_COLOR);
        }

        @Override
        public String format() {
            return TextFormatting.UNDERLINE.toString();
        }

        @Override
        public void handleMouseClick(GuiScreen parent) {
            if (this.disabled) {
                return;
            }
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiCustomConfirmOpenLink(parent, this.toCopy, null));
        }

        @Override
        public List<String> tooltip(boolean mouseOver) {
            if (this.disabled) {
                return null;
            }
            if (mouseOver) {
                return ImmutableList.of((Object)LabsTranslate.translate("nomilabs.gui.bqu.custom.link.tooltip", new Object[0]));
            }
            return null;
        }
    }

    public static class InteractiveCopy
    extends InteractiveState {
        public static final GuiColorStatic DEFAULT_COLOR = new GuiColorStatic(10025880);
        public static final GuiColorStatic OVER_COLOR = new GuiColorStatic(0xFF55FF);
        public static final float TRANSITION_TIME = 150.0f;
        public static final int DISPLAY_COPIED_TIME = 1000;
        protected final GuiColorTransition color;
        protected final boolean disabled;
        protected final String toCopy;
        protected long lastMouseTransitionUpdate;
        protected float mouseTransition = 0.0f;
        protected boolean mouseOver = false;
        protected long lastCopy = 0L;

        public InteractiveCopy(String toCopy, boolean disabled) {
            this(toCopy, disabled, (IGuiColor)DEFAULT_COLOR, (IGuiColor)OVER_COLOR);
        }

        protected InteractiveCopy(String toCopy, boolean disabled, IGuiColor defaultColor, IGuiColor overColor) {
            this.disabled = disabled;
            this.toCopy = toCopy;
            this.lastMouseTransitionUpdate = System.currentTimeMillis();
            this.color = new GuiColorTransition(overColor, defaultColor);
            this.color.setupBlending(true, 1.0f).setBlendDriver((IValueIO)new ValueFuncIO(() -> Float.valueOf(this.mouseTransition)));
        }

        @Override
        public void handleMouseOver(boolean mouseOver) {
            if (this.disabled) {
                return;
            }
            this.mouseOver = mouseOver;
            long mills = System.currentTimeMillis();
            if (mouseOver && this.mouseTransition < 1.0f) {
                this.mouseTransition += (float)(mills - this.lastMouseTransitionUpdate) / 150.0f;
                this.mouseTransition = Math.min(this.mouseTransition, 1.0f);
            } else if (this.mouseTransition > 0.0f) {
                this.mouseTransition -= (float)(mills - this.lastMouseTransitionUpdate) / 150.0f;
                this.mouseTransition = Math.max(this.mouseTransition, 0.0f);
            }
            this.lastMouseTransitionUpdate = mills;
        }

        @Override
        public void handleMouseClick(GuiScreen parent) {
            if (this.disabled) {
                return;
            }
            GuiScreen.func_146275_d((String)this.toCopy);
            this.lastCopy = System.currentTimeMillis();
        }

        @Override
        public String format() {
            return TextFormatting.ITALIC.toString();
        }

        @Override
        public GuiColorTransition color() {
            return this.color;
        }

        @Override
        public List<String> tooltip(boolean mouseOver) {
            if (this.disabled) {
                return null;
            }
            if (System.currentTimeMillis() - this.lastCopy < 1000L) {
                return ImmutableList.of((Object)LabsTranslate.translate("nomilabs.gui.bqu.custom.copied.tooltip", new Object[0]));
            }
            if (mouseOver) {
                return ImmutableList.of((Object)LabsTranslate.translate("nomilabs.gui.bqu.custom.copy.tooltip", new Object[0]));
            }
            return null;
        }
    }
}

