/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.integration.betterquesting;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.questing.IQuest;
import betterquesting.questing.QuestDatabase;
import com.nomiceu.nomilabs.config.LabsConfig;
import com.nomiceu.nomilabs.util.LabsModeHelper;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LabsTierHelper {
    private static int[] IDS;
    private static String[] SLUGS;
    private static String[] NAMES;
    private static UUID uuid;
    private static Integer cacheID;

    public static void preInit() {
        boolean normal = LabsModeHelper.isNormal();
        if (!normal && !LabsModeHelper.isExpert() && LabsConfig.advanced.tierSettings.defaultMode == LabsConfig.Advanced.TierSettings.DefaultModeType.NORMAL) {
            normal = true;
        }
        if (normal) {
            IDS = LabsConfig.advanced.tierSettings.normalModeQuestIds;
            SLUGS = LabsConfig.advanced.tierSettings.normalModeSlugs;
            NAMES = LabsConfig.advanced.tierSettings.normalModeFormatted;
        } else {
            IDS = LabsConfig.advanced.tierSettings.expertModeQuestIds;
            SLUGS = LabsConfig.advanced.tierSettings.expertModeSlugs;
            NAMES = LabsConfig.advanced.tierSettings.expertModeFormatted;
        }
        uuid = null;
        cacheID = null;
    }

    public static String getTierSlug() {
        return LabsTierHelper.getOrDefault(LabsConfig.advanced.tierSettings.defaultSlug, SLUGS);
    }

    public static String getTierName() {
        return LabsTierHelper.getOrDefault(LabsConfig.advanced.tierSettings.defaultFormatted, NAMES);
    }

    private static void rebuildCacheTier() {
        UUID inputUuid;
        uuid = inputUuid = QuestingAPI.getQuestingUUID((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (inputUuid == null) {
            cacheID = null;
            return;
        }
        for (int i = IDS.length - 1; i >= 0; --i) {
            IQuest quest = (IQuest)QuestDatabase.INSTANCE.getValue(IDS[i]);
            if (quest == null || !quest.isComplete(uuid)) continue;
            cacheID = i;
            return;
        }
        cacheID = null;
    }

    private static void resetCacheTier() {
        uuid = null;
        cacheID = null;
    }

    private static String getOrDefault(String defaultValue, String[] list) {
        if (!Loader.isModLoaded((String)"betterquesting")) {
            return Minecraft.func_71410_x().field_71439_g == null ? "" : defaultValue;
        }
        if (Minecraft.func_71410_x().field_71439_g != null) {
            LabsTierHelper.rebuildCacheTier();
        } else {
            LabsTierHelper.resetCacheTier();
        }
        if (cacheID == null) {
            return uuid == null ? "" : defaultValue;
        }
        return list[cacheID];
    }
}

