/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.integration.betterquesting;

import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import com.nomiceu.nomilabs.integration.betterquesting.AccessibleGuiRectText;
import com.nomiceu.nomilabs.integration.betterquesting.DescriptionPart;
import com.nomiceu.nomilabs.integration.betterquesting.InteractiveState;
import com.nomiceu.nomilabs.integration.betterquesting.RenderDescriptionPart;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class PanelDescription
extends PanelTextBox {
    private final List<DescriptionPart> parts;
    private final List<InteractiveState> interactiveParts;
    private final GuiRectangle refRect;
    private final List<RenderDescriptionPart> renderParts;

    public PanelDescription(IGuiRect rect, String text) {
        super(rect, text, true);
        this.parts = DescriptionPart.splitString(text);
        this.interactiveParts = new ObjectArrayList();
        for (DescriptionPart part : this.parts) {
            if (!(part instanceof DescriptionPart.DescriptionInteractive)) continue;
            DescriptionPart.DescriptionInteractive interactive = (DescriptionPart.DescriptionInteractive)part;
            this.interactiveParts.add(interactive.getState());
        }
        this.refRect = new GuiRectangle(0, 0, 0, 0, 0);
        this.renderParts = new ObjectArrayList();
    }

    public void refreshParts() {
        this.renderParts.clear();
        this.refRect.x = this.getTransform().getX();
        this.refRect.y = this.getTransform().getY();
        this.refRect.w = this.getTransform().getWidth();
        ArrayDeque<DescriptionPart> extractedParts = new ArrayDeque<DescriptionPart>();
        for (InteractiveState interact : this.interactiveParts) {
            interact.clearParts();
        }
        for (DescriptionPart part : this.parts) {
            extractedParts.addLast(part);
        }
        ((AccessibleGuiRectText)this.getTransform()).labs$setHeight(this.addLineOfParts(extractedParts, 0));
        this.refRect.h = this.getTransform().getHeight();
    }

    private int addLineOfParts(Deque<DescriptionPart> parts, int yOffset) {
        RenderDescriptionPart render;
        int height = PanelDescription.fontRenderer().field_78288_b;
        for (int widthRemaining = this.refRect.getWidth(); !parts.isEmpty() && widthRemaining > 0; widthRemaining -= render.width()) {
            char charAtSplit;
            DescriptionPart part = parts.pollFirst();
            String renderText = part.toRenderText();
            int split = PanelDescription.fontRenderer().func_78259_e(renderText, widthRemaining);
            if (split >= renderText.length()) {
                render = part.toRender(this.refRect.getX() + this.refRect.getWidth() - widthRemaining, this.refRect.getY() + yOffset);
                this.renderParts.add(render);
                height = Math.max(height, render.height());
                continue;
            }
            if (split != 0) {
                render = part.toRender(this.refRect.getX() + this.refRect.getWidth() - widthRemaining, this.refRect.getY() + yOffset, split);
                height = Math.max(height, render.height());
                this.renderParts.add(render);
            }
            if ((charAtSplit = renderText.charAt(split)) == '\n' || charAtSplit == ' ') {
                ++split;
            }
            if (split >= renderText.length()) break;
            parts.addFirst(part.allAfter(split));
            break;
        }
        if (!parts.isEmpty()) {
            return this.addLineOfParts(parts, yOffset + height);
        }
        return yOffset + height;
    }

    public PanelTextBox setText(String text) {
        return this;
    }

    public void initPanel() {
        this.refreshParts();
    }

    public void drawPanel(int mx, int my, float partialTick) {
        if (!this.isRectEqual((IGuiRect)this.refRect, this.getTransform())) {
            this.refreshParts();
        }
        boolean findMouseOver = this.refRect.contains(mx, my);
        for (InteractiveState state : this.interactiveParts) {
            boolean mouseOver = false;
            if (findMouseOver) {
                for (RenderDescriptionPart.RenderDescriptionInteractive part : state.parts) {
                    if (!part.isMouseOver(mx, my)) continue;
                    mouseOver = true;
                    break;
                }
                findMouseOver = !mouseOver;
            }
            state.handleMouseOver(mouseOver);
        }
        for (RenderDescriptionPart part : this.renderParts) {
            part.render();
        }
    }

    public boolean onMouseClick(int mx, int my, int clickButton) {
        if (!this.refRect.contains(mx, my) || clickButton != 0) {
            return false;
        }
        for (InteractiveState state : this.interactiveParts) {
            boolean mouseOver = false;
            for (RenderDescriptionPart.RenderDescriptionInteractive part : state.parts) {
                if (!part.isMouseOver(mx, my)) continue;
                mouseOver = true;
                break;
            }
            if (!mouseOver) continue;
            state.handleMouseClick(Minecraft.func_71410_x().field_71462_r);
            return true;
        }
        return false;
    }

    public List<String> getTooltip(int mx, int my) {
        if (!this.refRect.contains(mx, my)) {
            return null;
        }
        List<String> result = null;
        boolean findMouseOver = this.refRect.contains(mx, my);
        for (InteractiveState state : this.interactiveParts) {
            List<String> tooltip;
            boolean mouseOver = false;
            if (findMouseOver) {
                for (RenderDescriptionPart.RenderDescriptionInteractive part : state.parts) {
                    if (!part.isMouseOver(mx, my)) continue;
                    mouseOver = true;
                    break;
                }
                boolean bl = findMouseOver = !mouseOver;
            }
            if ((tooltip = state.tooltip(mouseOver)) == null) continue;
            if (!mouseOver) {
                return tooltip;
            }
            result = tooltip;
        }
        return result;
    }

    private boolean isRectEqual(IGuiRect r1, IGuiRect r2) {
        return r1.getX() == r2.getX() && r1.getY() == r2.getY() && r1.getWidth() == r2.getWidth() && r1.getHeight() == r2.getHeight();
    }

    public static FontRenderer fontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }
}

