/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.integration.betterquesting;

import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import com.nomiceu.nomilabs.integration.betterquesting.InteractiveState;
import com.nomiceu.nomilabs.integration.betterquesting.PanelDescription;

public abstract class RenderDescriptionPart {
    protected final int width;
    protected final int x;
    protected final int y;

    protected RenderDescriptionPart(int width, int x, int y) {
        this.width = width;
        this.x = x;
        this.y = y;
    }

    public int height() {
        return PanelDescription.fontRenderer().field_78288_b;
    }

    public int width() {
        return this.width;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public abstract void render();

    public static class RenderDescriptionInteractive
    extends RenderDescriptionPart
    implements InteractivableRender {
        protected final String text;
        protected final InteractiveState interactive;

        public RenderDescriptionInteractive(String text, int width, int x, int y, InteractiveState interactive) {
            super(width, x, y);
            this.text = text;
            this.interactive = interactive;
            this.interactive.addPart(this);
        }

        @Override
        public int height() {
            return super.height() + 1;
        }

        @Override
        public void render() {
            PanelDescription.fontRenderer().func_78276_b(this.text, this.x, this.y, this.interactive.color().getRGB());
        }

        @Override
        public boolean isMouseOver(int mx, int my) {
            return mx >= this.x && mx <= this.x + this.width && my >= this.y && my <= this.y + PanelDescription.fontRenderer().field_78288_b;
        }
    }

    public static class RenderDescriptionText
    extends RenderDescriptionPart {
        public static final GuiColorStatic DEFAULT_COLOR = new GuiColorStatic(0xFFFFFF);
        protected final String text;

        public RenderDescriptionText(String text, int width, int x, int y) {
            super(width, x, y);
            this.text = text;
        }

        @Override
        public void render() {
            PanelDescription.fontRenderer().func_78276_b(this.text, this.x, this.y, DEFAULT_COLOR.getRGB());
        }
    }

    public static interface InteractivableRender {
        public boolean isMouseOver(int var1, int var2);
    }
}

