/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.integration.draconicevolution;

import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.ModelUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.blocks.tileentity.IMultiBlockPart;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyStorageCore;
import com.brandon3055.draconicevolution.blocks.tileentity.TileInvisECoreBlock;
import com.brandon3055.draconicevolution.client.gui.GuiEnergyCore;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.world.EnergyCoreStructure;
import com.nomiceu.nomilabs.NomiLabs;
import com.nomiceu.nomilabs.integration.draconicevolution.BlockStateMultiblockHelper;
import com.nomiceu.nomilabs.integration.draconicevolution.BlockStateMultiblockStorage;
import com.nomiceu.nomilabs.integration.draconicevolution.BlockStates;
import com.nomiceu.nomilabs.integration.draconicevolution.DraconicHelpers;
import com.nomiceu.nomilabs.integration.draconicevolution.TileInvisECoreBlockState;
import gregtech.api.unification.material.Material;
import gregtech.common.blocks.BlockCompressed;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockStateEnergyCoreStructure
extends EnergyCoreStructure {
    private static final int FLAG_RENDER = 0;
    private static final int FLAG_FORME = 1;
    private static final int FLAG_REVERT = 2;
    private static final int TIER_AMOUNT = 8;
    private final TileEnergyStorageCore core;
    private final BlockStateMultiblockHelper helper;
    private final BlockStateMultiblockStorage[] structureTiers;
    public final BlockStates e;
    public final BlockStates X;
    public final BlockStates R;
    public final BlockStates D;
    public final BlockStates A;

    public BlockStateEnergyCoreStructure(TileEnergyStorageCore core) {
        this.core = core;
        this.helper = new BlockStateMultiblockHelper();
        this.structureTiers = new BlockStateMultiblockStorage[8];
        List<ItemStack> gtDraconium = DraconicHelpers.getGTDraconium();
        List<ItemStack> defaultDraconium = DraconicHelpers.getDefaultDraconium();
        List<ItemStack> gtAwakened = DraconicHelpers.getGTAwakenedDraconium();
        List<ItemStack> defaultAwakened = DraconicHelpers.getDefaultAwakened();
        this.e = BlockStates.wildcard();
        this.X = BlockStates.of((Block)DEFeatures.energyStorageCore);
        this.R = BlockStates.of(Blocks.field_150451_bX);
        this.D = BlockStates.of(gtDraconium.get(0), defaultDraconium.get(0));
        this.A = BlockStates.of(gtAwakened.get(0), defaultAwakened.get(0));
        this.structureTiers[0] = this.buildTier1();
        this.structureTiers[1] = this.buildTier2();
        this.structureTiers[2] = this.buildTier3();
        this.structureTiers[3] = this.buildTier4();
        this.structureTiers[4] = this.buildTier5();
        this.structureTiers[5] = this.buildTier6();
        this.structureTiers[6] = this.buildTier7();
        this.structureTiers[7] = this.buildTierOMG();
    }

    public BlockStateMultiblockHelper getHelper() {
        return this.helper;
    }

    public boolean checkTier(int tier) {
        BlockPos offset = this.getCoreOffset(tier);
        if (tier <= 0) {
            NomiLabs.LOGGER.error("[EnergyCoreStructure] Tier value to small. As far as TileEnergyStorageCore is concerned the tiers now start at 1 not 0. This class automatically handles the conversion now");
            return false;
        }
        if (tier > 8) {
            NomiLabs.LOGGER.error("[EnergyCoreStructure] What exactly were you expecting after Tier 8? Infinity.MAX_VALUE?");
            return false;
        }
        return this.structureTiers[tier - 1].checkStructure(this.core.func_145831_w(), this.core.func_174877_v().func_177971_a((Vec3i)offset));
    }

    public void placeTier(int tier) {
        BlockPos offset = this.getCoreOffset(tier);
        if (tier <= 0) {
            NomiLabs.LOGGER.error("[EnergyCoreStructure] Tier value to small. As far as TileEnergyStorageCore is concerned the tiers now start at 1 not 0. This class automatically handles the conversion now");
            return;
        }
        if (tier > 8) {
            NomiLabs.LOGGER.error("[EnergyCoreStructure] What exactly were you expecting after Tier 8? Infinity.MAX_VALUE?");
            return;
        }
        this.structureTiers[tier - 1].placeStructure(this.core.func_145831_w(), this.core.func_174877_v().func_177971_a((Vec3i)offset));
    }

    public void renderTier(int tier) {
        this.forTier(tier, 0);
    }

    public void formTier(int tier) {
        coreForming = true;
        this.forTier(tier, 1);
        coreForming = false;
    }

    public void revertTier(int tier) {
        this.forTier(tier, 2);
    }

    private void forTier(int tier, int flag) {
        if (--tier < 0) {
            NomiLabs.LOGGER.error("[EnergyCoreStructure] Tier value to small. As far as TileEnergyStorageCore is concerned the tiers now start at 1 not 0. This class automatically handles the conversion now");
        } else if (tier >= this.structureTiers.length) {
            NomiLabs.LOGGER.error("[EnergyCoreStructure#placeTier] What exactly were you expecting after Tier 8? Infinity.MAX_VALUE?");
        } else {
            this.structureTiers[tier].forEachInStructure(this.core.func_145831_w(), this.core.func_174877_v().func_177971_a((Vec3i)this.getCoreOffset(tier + 1)), flag);
        }
    }

    public BlockStateMultiblockStorage getStorageForTier(int tier) {
        return this.structureTiers[tier - 1];
    }

    public void forBlock(BlockStates states, World world, BlockPos pos, BlockPos startPos, int flag) {
        TileEntity tile;
        if (states == null) {
            return;
        }
        if (states.isWildcard() || states.equals(this.X)) {
            return;
        }
        if (flag == 0) {
            if (world.field_72995_K) {
                this.renderBuildGuide(states, world, pos, startPos, flag);
            }
        } else if (flag == 1) {
            world.func_175656_a(pos, DEFeatures.invisECoreBlock.func_176223_P());
            TileEntity tile2 = world.func_175625_s(pos);
            if (tile2 instanceof TileInvisECoreBlock) {
                TileInvisECoreBlock invis = (TileInvisECoreBlock)tile2;
                invis.blockName = Objects.requireNonNull(states.getDefault().func_177230_c().getRegistryName()).toString();
                TileInvisECoreBlockState invisState = (TileInvisECoreBlockState)invis;
                if (BlockStates.statesEqual(states.getDefault(), states.getDefault().func_177230_c().func_176223_P())) {
                    invisState.labs$setIsDefault();
                } else {
                    invisState.labs$setMetadata(states.getDefault().func_177230_c().func_176201_c(states.getDefault()));
                }
                invis.setController((IMultiBlockPart)this.core);
            }
        } else if (flag == 2 && (tile = world.func_175625_s(pos)) instanceof TileInvisECoreBlock) {
            ((TileInvisECoreBlock)tile).revert();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void renderBuildGuide(BlockStates states, World world, BlockPos pos, BlockPos startPos, int flag) {
        boolean invalid;
        Vec3D corePos = Vec3D.getCenter((BlockPos)startPos.func_177973_b((Vec3i)this.getCoreOffset(this.core.tier.value)));
        double dist = Utils.getDistanceAtoB((Vec3D)corePos, (Vec3D)Vec3D.getCenter((BlockPos)pos));
        double pDist = Minecraft.func_71410_x().field_71439_g.func_70011_f(corePos.x, corePos.y, corePos.z);
        if (GuiEnergyCore.layer != -1) {
            pDist = GuiEnergyCore.layer + 2;
        }
        IBlockState atState = world.func_180495_p(pos);
        boolean bl = invalid = !world.func_175623_d(pos) && !DraconicHelpers.validState(states, atState, false);
        if (dist + 2.0 > pDist && !invalid) {
            return;
        }
        BlockPos translation = new BlockPos(pos.func_177958_n() - startPos.func_177958_n(), pos.func_177956_o() - startPos.func_177956_o(), pos.func_177952_p() - startPos.func_177952_p());
        translation = translation.func_177971_a((Vec3i)this.getCoreOffset(this.core.tier.value));
        int alpha = -16777216;
        if (invalid) {
            alpha = (int)((Math.sin((double)ClientEventHandler.elapsedTicks / 20.0) + 1.0) / 2.0 * 255.0) << 24;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)translation.func_177958_n(), (float)translation.func_177956_o(), (float)translation.func_177952_p());
        if (invalid) {
            GlStateManager.func_179097_i();
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            double s = Math.sin((double)ClientEventHandler.elapsedTicks / 10.0) * 0.1;
            GlStateManager.func_179139_a((double)(0.8 + s), (double)(0.8 + s), (double)(0.8 + s));
            GlStateManager.func_179137_b((double)(0.1 - s), (double)(0.1 - s), (double)(0.1 - s));
        } else {
            GlStateManager.func_179139_a((double)0.8, (double)0.8, (double)0.8);
            GlStateManager.func_179137_b((double)0.1, (double)0.1, (double)0.1);
        }
        float brightnessX = OpenGlHelper.lastBrightnessX;
        float brightnessY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)150.0f, (float)150.0f);
        List blockQuads = ModelUtils.getModelQuads((IBlockState)states.getDefault());
        Block block = states.getDefault().func_177230_c();
        if (block instanceof BlockCompressed) {
            BlockCompressed compressed = (BlockCompressed)block;
            Material material = compressed.getGtMaterial(states.getDefault());
            int color = material.getMaterialRGB();
            int r = (color & 0xFF0000) >> 16;
            int g = (color & 0xFF00) >> 8;
            int b = color & 0xFF;
            if (invalid) {
                r = 255;
                g = 0;
                b = 0;
            } else {
                r = MathHelper.func_76125_a((int)(r - 50), (int)0, (int)255);
                g = MathHelper.func_76125_a((int)(g - 50), (int)0, (int)255);
                b = MathHelper.func_76125_a((int)(b - 50), (int)0, (int)255);
            }
            ModelUtils.renderQuadsRGB((List)blockQuads, (float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f));
        } else {
            ModelUtils.renderQuadsARGB((List)blockQuads, (int)((invalid ? 0x500000 : 0x808080) | alpha));
        }
        if (invalid) {
            GlStateManager.func_179126_j();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)brightnessX, (float)brightnessY);
        GlStateManager.func_179121_F();
    }

    public boolean checkBlock(BlockStates states, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileInvisECoreBlock) {
            TileInvisECoreBlockState invisState;
            TileInvisECoreBlock invis = (TileInvisECoreBlock)tile;
            if (invis.blockName.equals(Objects.requireNonNull(states.getDefault().func_177230_c().getRegistryName()).toString()) && ((invisState = (TileInvisECoreBlockState)invis).labs$getDefault() ? BlockStates.statesEqual(states.getDefault(), states.getDefault().func_177230_c().func_176223_P()) : states.getDefault().func_177230_c().func_176201_c(states.getDefault()) == invisState.labs$getMetadata())) {
                return true;
            }
        }
        return this.helper.checkBlock(states, world, pos);
    }

    public BlockPos getCoreOffset(int tier) {
        int offset = tier == 1 ? 0 : (tier == 2 || tier == 3 ? -1 : -(tier - 2));
        return new BlockPos(offset, offset, offset);
    }

    public void setBlock(BlockStates states, World world, BlockPos pos) {
        if (states == null) {
            return;
        }
        if (!states.equals(this.X)) {
            this.helper.setBlock(states, world, pos);
        }
    }

    private BlockStateMultiblockStorage buildTier1() {
        BlockStateMultiblockStorage storage = new BlockStateMultiblockStorage(1, this.helper, this);
        storage.addRow(this.X);
        return storage;
    }

    private BlockStateMultiblockStorage buildTier2() {
        BlockStateMultiblockStorage storage = new BlockStateMultiblockStorage(3, this.helper, this);
        storage.addRow(this.e, this.e, this.e);
        storage.addRow(this.e, this.D, this.e);
        storage.addRow(this.e, this.e, this.e);
        storage.newLayer();
        storage.addRow(this.e, this.D, this.e);
        storage.addRow(this.D, this.X, this.D);
        storage.addRow(this.e, this.D, this.e);
        storage.mirrorHalf();
        return storage;
    }

    private BlockStateMultiblockStorage buildTier3() {
        BlockStateMultiblockStorage storage = new BlockStateMultiblockStorage(3, this.helper, this);
        storage.addRow(this.D, this.D, this.D);
        storage.addRow(this.D, this.D, this.D);
        storage.addRow(this.D, this.D, this.D);
        storage.newLayer();
        storage.addRow(this.D, this.D, this.D);
        storage.addRow(this.D, this.X, this.D);
        storage.addRow(this.D, this.D, this.D);
        storage.mirrorHalf();
        return storage;
    }

    private BlockStateMultiblockStorage buildTier4() {
        BlockStateMultiblockStorage storage = new BlockStateMultiblockStorage(5, this.helper, this);
        storage.addRow(this.e, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.D, this.D, this.D, this.e);
        storage.addRow(this.e, this.D, this.D, this.D, this.e);
        storage.addRow(this.e, this.D, this.D, this.D, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.e);
        storage.newLayer();
        storage.addRow(this.e, this.D, this.D, this.D, this.e);
        storage.addRow(this.D, this.R, this.R, this.R, this.D);
        storage.addRow(this.D, this.R, this.R, this.R, this.D);
        storage.addRow(this.D, this.R, this.R, this.R, this.D);
        storage.addRow(this.e, this.D, this.D, this.D, this.e);
        storage.newLayer();
        storage.addRow(this.e, this.D, this.D, this.D, this.e);
        storage.addRow(this.D, this.R, this.R, this.R, this.D);
        storage.addRow(this.D, this.R, this.X, this.R, this.D);
        storage.addRow(this.D, this.R, this.R, this.R, this.D);
        storage.addRow(this.e, this.D, this.D, this.D, this.e);
        storage.mirrorHalf();
        return storage;
    }

    private BlockStateMultiblockStorage buildTier5() {
        BlockStateMultiblockStorage storage = new BlockStateMultiblockStorage(7, this.helper, this);
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.D, this.D, this.D, this.e, this.e);
        storage.addRow(this.e, this.e, this.D, this.D, this.D, this.e, this.e);
        storage.addRow(this.e, this.e, this.D, this.D, this.D, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.newLayer();
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.D, this.D, this.D, this.e, this.e);
        storage.addRow(this.e, this.D, this.R, this.R, this.R, this.D, this.e);
        storage.addRow(this.e, this.D, this.R, this.R, this.R, this.D, this.e);
        storage.addRow(this.e, this.D, this.R, this.R, this.R, this.D, this.e);
        storage.addRow(this.e, this.e, this.D, this.D, this.D, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.newLayer();
        storage.addRow(this.e, this.e, this.D, this.D, this.D, this.e, this.e);
        storage.addRow(this.e, this.D, this.R, this.R, this.R, this.D, this.e);
        storage.addRow(this.D, this.R, this.R, this.R, this.R, this.R, this.D);
        storage.addRow(this.D, this.R, this.R, this.R, this.R, this.R, this.D);
        storage.addRow(this.D, this.R, this.R, this.R, this.R, this.R, this.D);
        storage.addRow(this.e, this.D, this.R, this.R, this.R, this.D, this.e);
        storage.addRow(this.e, this.e, this.D, this.D, this.D, this.e, this.e);
        storage.newLayer();
        storage.addRow(this.e, this.e, this.D, this.D, this.D, this.e, this.e);
        storage.addRow(this.e, this.D, this.R, this.R, this.R, this.D, this.e);
        storage.addRow(this.D, this.R, this.R, this.R, this.R, this.R, this.D);
        storage.addRow(this.D, this.R, this.R, this.X, this.R, this.R, this.D);
        storage.addRow(this.D, this.R, this.R, this.R, this.R, this.R, this.D);
        storage.addRow(this.e, this.D, this.R, this.R, this.R, this.D, this.e);
        storage.addRow(this.e, this.e, this.D, this.D, this.D, this.e, this.e);
        storage.mirrorHalf();
        return storage;
    }

    private BlockStateMultiblockStorage buildTier6() {
        BlockStateMultiblockStorage storage = new BlockStateMultiblockStorage(9, this.helper, this);
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.D, this.D, this.D, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.D, this.D, this.D, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.D, this.D, this.D, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.newLayer();
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.D, this.D, this.D, this.D, this.D, this.e, this.e);
        storage.addRow(this.e, this.e, this.D, this.R, this.R, this.R, this.D, this.e, this.e);
        storage.addRow(this.e, this.e, this.D, this.R, this.R, this.R, this.D, this.e, this.e);
        storage.addRow(this.e, this.e, this.D, this.R, this.R, this.R, this.D, this.e, this.e);
        storage.addRow(this.e, this.e, this.D, this.D, this.D, this.D, this.D, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.newLayer();
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.D, this.D, this.D, this.D, this.D, this.e, this.e);
        storage.addRow(this.e, this.D, this.R, this.R, this.R, this.R, this.R, this.D, this.e);
        storage.addRow(this.e, this.D, this.R, this.R, this.R, this.R, this.R, this.D, this.e);
        storage.addRow(this.e, this.D, this.R, this.R, this.R, this.R, this.R, this.D, this.e);
        storage.addRow(this.e, this.D, this.R, this.R, this.R, this.R, this.R, this.D, this.e);
        storage.addRow(this.e, this.D, this.R, this.R, this.R, this.R, this.R, this.D, this.e);
        storage.addRow(this.e, this.e, this.D, this.D, this.D, this.D, this.D, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.newLayer();
        storage.addRow(this.e, this.e, this.e, this.D, this.D, this.D, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.D, this.R, this.R, this.R, this.D, this.e, this.e);
        storage.addRow(this.e, this.D, this.R, this.R, this.R, this.R, this.R, this.D, this.e);
        storage.addRow(this.D, this.R, this.R, this.R, this.R, this.R, this.R, this.R, this.D);
        storage.addRow(this.D, this.R, this.R, this.R, this.R, this.R, this.R, this.R, this.D);
        storage.addRow(this.D, this.R, this.R, this.R, this.R, this.R, this.R, this.R, this.D);
        storage.addRow(this.e, this.D, this.R, this.R, this.R, this.R, this.R, this.D, this.e);
        storage.addRow(this.e, this.e, this.D, this.R, this.R, this.R, this.D, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.D, this.D, this.D, this.e, this.e, this.e);
        storage.newLayer();
        storage.addRow(this.e, this.e, this.e, this.D, this.D, this.D, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.D, this.R, this.R, this.R, this.D, this.e, this.e);
        storage.addRow(this.e, this.D, this.R, this.R, this.R, this.R, this.R, this.D, this.e);
        storage.addRow(this.D, this.R, this.R, this.R, this.R, this.R, this.R, this.R, this.D);
        storage.addRow(this.D, this.R, this.R, this.R, this.X, this.R, this.R, this.R, this.D);
        storage.addRow(this.D, this.R, this.R, this.R, this.R, this.R, this.R, this.R, this.D);
        storage.addRow(this.e, this.D, this.R, this.R, this.R, this.R, this.R, this.D, this.e);
        storage.addRow(this.e, this.e, this.D, this.R, this.R, this.R, this.D, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.D, this.D, this.D, this.e, this.e, this.e);
        storage.mirrorHalf();
        return storage;
    }

    private BlockStateMultiblockStorage buildTier7() {
        BlockStateMultiblockStorage storage = new BlockStateMultiblockStorage(11, this.helper, this);
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.D, this.D, this.D, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.D, this.D, this.D, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.D, this.D, this.D, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.newLayer();
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.D, this.D, this.D, this.D, this.D, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.D, this.R, this.R, this.R, this.D, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.D, this.R, this.R, this.R, this.D, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.D, this.R, this.R, this.R, this.D, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.D, this.D, this.D, this.D, this.D, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.newLayer();
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.D, this.D, this.D, this.D, this.D, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.D, this.R, this.R, this.R, this.R, this.R, this.D, this.e, this.e);
        storage.addRow(this.e, this.e, this.D, this.R, this.R, this.R, this.R, this.R, this.D, this.e, this.e);
        storage.addRow(this.e, this.e, this.D, this.R, this.R, this.R, this.R, this.R, this.D, this.e, this.e);
        storage.addRow(this.e, this.e, this.D, this.R, this.R, this.R, this.R, this.R, this.D, this.e, this.e);
        storage.addRow(this.e, this.e, this.D, this.R, this.R, this.R, this.R, this.R, this.D, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.D, this.D, this.D, this.D, this.D, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.newLayer();
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.D, this.D, this.D, this.D, this.D, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.D, this.R, this.R, this.R, this.R, this.R, this.D, this.e, this.e);
        storage.addRow(this.e, this.D, this.R, this.R, this.R, this.R, this.R, this.R, this.R, this.D, this.e);
        storage.addRow(this.e, this.D, this.R, this.R, this.R, this.R, this.R, this.R, this.R, this.D, this.e);
        storage.addRow(this.e, this.D, this.R, this.R, this.R, this.R, this.R, this.R, this.R, this.D, this.e);
        storage.addRow(this.e, this.D, this.R, this.R, this.R, this.R, this.R, this.R, this.R, this.D, this.e);
        storage.addRow(this.e, this.D, this.R, this.R, this.R, this.R, this.R, this.R, this.R, this.D, this.e);
        storage.addRow(this.e, this.e, this.D, this.R, this.R, this.R, this.R, this.R, this.D, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.D, this.D, this.D, this.D, this.D, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
        storage.newLayer();
        storage.addRow(this.e, this.e, this.e, this.e, this.D, this.D, this.D, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.D, this.R, this.R, this.R, this.D, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.D, this.R, this.R, this.R, this.R, this.R, this.D, this.e, this.e);
        storage.addRow(this.e, this.D, this.R, this.R, this.R, this.R, this.R, this.R, this.R, this.D, this.e);
        storage.addRow(this.D, this.R, this.R, this.R, this.R, this.R, this.R, this.R, this.R, this.R, this.D);
        storage.addRow(this.D, this.R, this.R, this.R, this.R, this.R, this.R, this.R, this.R, this.R, this.D);
        storage.addRow(this.D, this.R, this.R, this.R, this.R, this.R, this.R, this.R, this.R, this.R, this.D);
        storage.addRow(this.e, this.D, this.R, this.R, this.R, this.R, this.R, this.R, this.R, this.D, this.e);
        storage.addRow(this.e, this.e, this.D, this.R, this.R, this.R, this.R, this.R, this.D, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.D, this.R, this.R, this.R, this.D, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.D, this.D, this.D, this.e, this.e, this.e, this.e);
        storage.newLayer();
        storage.addRow(this.e, this.e, this.e, this.e, this.D, this.D, this.D, this.e, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.D, this.R, this.R, this.R, this.D, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.D, this.R, this.R, this.R, this.R, this.R, this.D, this.e, this.e);
        storage.addRow(this.e, this.D, this.R, this.R, this.R, this.R, this.R, this.R, this.R, this.D, this.e);
        storage.addRow(this.D, this.R, this.R, this.R, this.R, this.R, this.R, this.R, this.R, this.R, this.D);
        storage.addRow(this.D, this.R, this.R, this.R, this.R, this.X, this.R, this.R, this.R, this.R, this.D);
        storage.addRow(this.D, this.R, this.R, this.R, this.R, this.R, this.R, this.R, this.R, this.R, this.D);
        storage.addRow(this.e, this.D, this.R, this.R, this.R, this.R, this.R, this.R, this.R, this.D, this.e);
        storage.addRow(this.e, this.e, this.D, this.R, this.R, this.R, this.R, this.R, this.D, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.D, this.R, this.R, this.R, this.D, this.e, this.e, this.e);
        storage.addRow(this.e, this.e, this.e, this.e, this.D, this.D, this.D, this.e, this.e, this.e, this.e);
        storage.mirrorHalf();
        return storage;
    }

    private BlockStateMultiblockStorage buildTierOMG() {
        BlockStateMultiblockStorage storage = new BlockStateMultiblockStorage(13, this.helper, this);
        if (DEConfig.hardMode) {
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.newLayer();
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.newLayer();
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.e, this.e);
            storage.addRow(this.e, this.e, this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.A, this.A, this.e, this.e);
            storage.addRow(this.e, this.e, this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.A, this.A, this.e, this.e);
            storage.addRow(this.e, this.e, this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.A, this.A, this.e, this.e);
            storage.addRow(this.e, this.e, this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.A, this.A, this.e, this.e);
            storage.addRow(this.e, this.e, this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.A, this.A, this.e, this.e);
            storage.addRow(this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.newLayer();
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.e, this.e);
            storage.addRow(this.e, this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.A, this.e);
            storage.addRow(this.e, this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.A, this.e);
            storage.addRow(this.e, this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.A, this.e);
            storage.addRow(this.e, this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.A, this.e);
            storage.addRow(this.e, this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.A, this.e);
            storage.addRow(this.e, this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.A, this.e);
            storage.addRow(this.e, this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.A, this.e);
            storage.addRow(this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.newLayer();
            storage.addRow(this.e, this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.A, this.A, this.e, this.e);
            storage.addRow(this.e, this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.A, this.e);
            storage.addRow(this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.A);
            storage.addRow(this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.A);
            storage.addRow(this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.A);
            storage.addRow(this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.A);
            storage.addRow(this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.A);
            storage.addRow(this.e, this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.A, this.e);
            storage.addRow(this.e, this.e, this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.A, this.A, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e, this.e);
            storage.newLayer();
            storage.addRow(this.e, this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.A, this.A, this.e, this.e);
            storage.addRow(this.e, this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.A, this.e);
            storage.addRow(this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.A);
            storage.addRow(this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.A);
            storage.addRow(this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.A);
            storage.addRow(this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.A);
            storage.addRow(this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.A);
            storage.addRow(this.e, this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.A, this.e);
            storage.addRow(this.e, this.e, this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.A, this.A, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e, this.e);
            storage.newLayer();
            storage.addRow(this.e, this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.A, this.A, this.e, this.e);
            storage.addRow(this.e, this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.A, this.e);
            storage.addRow(this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.A);
            storage.addRow(this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.A);
            storage.addRow(this.A, this.A, this.D, this.D, this.D, this.D, this.X, this.D, this.D, this.D, this.D, this.A, this.A);
            storage.addRow(this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.A);
            storage.addRow(this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.A);
            storage.addRow(this.e, this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.A, this.e);
            storage.addRow(this.e, this.e, this.A, this.A, this.D, this.D, this.D, this.D, this.D, this.A, this.A, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e, this.e);
        } else {
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.newLayer();
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.newLayer();
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.e, this.e);
            storage.addRow(this.e, this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.e, this.e);
            storage.addRow(this.e, this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.e, this.e);
            storage.addRow(this.e, this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.e, this.e);
            storage.addRow(this.e, this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.e, this.e);
            storage.addRow(this.e, this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.e, this.e);
            storage.addRow(this.e, this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.newLayer();
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.e, this.e);
            storage.addRow(this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.e);
            storage.addRow(this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.e);
            storage.addRow(this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.e);
            storage.addRow(this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.e);
            storage.addRow(this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.e);
            storage.addRow(this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.e);
            storage.addRow(this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.e);
            storage.addRow(this.e, this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e, this.e);
            storage.newLayer();
            storage.addRow(this.e, this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.e, this.e);
            storage.addRow(this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.e);
            storage.addRow(this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A);
            storage.addRow(this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A);
            storage.addRow(this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A);
            storage.addRow(this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A);
            storage.addRow(this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A);
            storage.addRow(this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.e);
            storage.addRow(this.e, this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e, this.e);
            storage.newLayer();
            storage.addRow(this.e, this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.e, this.e);
            storage.addRow(this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.e);
            storage.addRow(this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A);
            storage.addRow(this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A);
            storage.addRow(this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A);
            storage.addRow(this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A);
            storage.addRow(this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A);
            storage.addRow(this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.e);
            storage.addRow(this.e, this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e, this.e);
            storage.newLayer();
            storage.addRow(this.e, this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.e, this.e);
            storage.addRow(this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.e);
            storage.addRow(this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A);
            storage.addRow(this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A);
            storage.addRow(this.A, this.D, this.D, this.D, this.D, this.D, this.X, this.D, this.D, this.D, this.D, this.D, this.A);
            storage.addRow(this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A);
            storage.addRow(this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A);
            storage.addRow(this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.e);
            storage.addRow(this.e, this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.D, this.D, this.A, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.A, this.D, this.D, this.D, this.D, this.D, this.A, this.e, this.e, this.e);
            storage.addRow(this.e, this.e, this.e, this.e, this.A, this.A, this.A, this.A, this.A, this.e, this.e, this.e, this.e);
        }
        storage.mirrorHalf();
        return storage;
    }
}

