/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.integration.draconicevolution;

import com.brandon3055.brandonscore.lib.MultiBlockStorage;
import com.brandon3055.brandonscore.utils.MultiBlockHelper;
import com.nomiceu.nomilabs.integration.draconicevolution.BlockStateEnergyCoreStructure;
import com.nomiceu.nomilabs.integration.draconicevolution.BlockStateMultiblockHelper;
import com.nomiceu.nomilabs.integration.draconicevolution.BlockStates;
import java.util.function.BiConsumer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class BlockStateMultiblockStorage
extends MultiBlockStorage {
    private final BlockStates[][][] structure;
    private final int size;
    private final BlockStateMultiblockHelper helper;
    private final BlockStateEnergyCoreStructure energyCoreStructure;
    private int xPos = 0;
    private int yPos = 0;

    public BlockStateMultiblockStorage(int size, BlockStateMultiblockHelper helper, BlockStateEnergyCoreStructure energyCoreStructure) {
        super(size, (MultiBlockHelper)helper);
        this.helper = helper;
        this.size = size;
        this.structure = new BlockStates[size][size][size];
        this.energyCoreStructure = energyCoreStructure;
    }

    public void addRow(BlockStates ... zRow) {
        if (zRow.length == this.size) {
            if (this.xPos >= this.size) {
                throw new RuntimeException("[MultiBlockStorage] Attempt to add too many zRow's to layer");
            }
            this.structure[this.xPos][this.yPos] = zRow;
            ++this.xPos;
        } else {
            throw new RuntimeException("[MultiBlockStorage] Attempt to add zRow larger or smaller then defined structure size");
        }
    }

    public void mirrorLayers(int minY, int maxY) {
        if (this.yPos < maxY) {
            throw new IllegalArgumentException("[MultiBlockStorage] Cannot mirror from minY " + minY + " to maxY " + maxY + " as have not reached maxY yet!");
        }
        for (int y = maxY - 1; y >= minY; --y) {
            if (y != minY || this.xPos != 0) {
                this.newLayer();
            }
            for (int x = 0; x < this.size; ++x) {
                this.addRow(this.structure[x][y]);
            }
        }
    }

    public void mirrorHalf() {
        this.mirrorLayers(0, this.size / 2);
    }

    public void newLayer() {
        this.xPos = 0;
        ++this.yPos;
        if (this.yPos >= this.size) {
            throw new RuntimeException("[MultiBlockStorage] Attempt to add too many layers to structure");
        }
    }

    public boolean checkStructure(World world, BlockPos startPos) {
        for (int x = 0; x < this.size; ++x) {
            for (int y = 0; y < this.size; ++y) {
                for (int z = 0; z < this.size; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (this.structure[x][y][z].isWildcard() || this.energyCoreStructure.checkBlock(this.structure[x][y][z], world, pos.func_177971_a((Vec3i)startPos))) continue;
                    this.helper.invalidBlock = startPos.func_177971_a((Vec3i)pos);
                    this.helper.expectedBlockState = this.structure[x][y][z].getDefault();
                    return false;
                }
            }
        }
        this.helper.invalidBlock = null;
        return true;
    }

    public void placeStructure(World world, BlockPos startPos) {
        this.forEachBlockStates(startPos, (pos, states) -> this.energyCoreStructure.setBlock((BlockStates)states, world, (BlockPos)pos));
    }

    public void forEachInStructure(World world, BlockPos startPos, int flag) {
        this.forEachBlockStates(startPos, (pos, states) -> this.energyCoreStructure.forBlock((BlockStates)states, world, (BlockPos)pos, startPos, flag));
    }

    public void forEachBlockStates(BlockPos startPos, BiConsumer<BlockPos, BlockStates> consumer) {
        for (int x = 0; x < this.size; ++x) {
            for (int y = 0; y < this.size; ++y) {
                for (int z = 0; z < this.size; ++z) {
                    if (this.structure[x][y][z].isWildcard()) continue;
                    consumer.accept(new BlockPos(x, y, z).func_177971_a((Vec3i)startPos), this.structure[x][y][z]);
                }
            }
        }
    }
}

