/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.integration.draconicevolution;

import java.util.Arrays;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public class BlockStates {
    private final IBlockState defaultBlockState;
    private final IBlockState[] substitutes;
    private final boolean wildcard;

    private BlockStates(IBlockState defaultBlockState, IBlockState[] substitutes, boolean wildcard) {
        this.defaultBlockState = defaultBlockState;
        this.substitutes = substitutes;
        this.wildcard = wildcard;
    }

    public static BlockStates of(IBlockState defaultBlockState) {
        return new BlockStates(defaultBlockState, new IBlockState[0], false);
    }

    public static BlockStates of(IBlockState defaultBlockState, IBlockState ... substitutes) {
        return new BlockStates(defaultBlockState, substitutes, false);
    }

    public static BlockStates of(ItemStack defaultBlockState) {
        return new BlockStates(BlockStates.transformStackToState(defaultBlockState), new IBlockState[0], false);
    }

    public static BlockStates of(ItemStack defaultBlockState, ItemStack ... substitutes) {
        return new BlockStates(BlockStates.transformStackToState(defaultBlockState), (IBlockState[])Arrays.stream(substitutes).map(BlockStates::transformStackToState).toArray(IBlockState[]::new), false);
    }

    public static BlockStates of(Block defaultBlock) {
        return new BlockStates(defaultBlock.func_176223_P(), new IBlockState[0], false);
    }

    public static BlockStates of(Block defaultBlock, Block ... substitutes) {
        return new BlockStates(defaultBlock.func_176223_P(), (IBlockState[])Arrays.stream(substitutes).map(Block::func_176223_P).toArray(IBlockState[]::new), false);
    }

    public static BlockStates wildcard() {
        return new BlockStates(null, new IBlockState[0], true);
    }

    public IBlockState getDefault() {
        return this.defaultBlockState;
    }

    public boolean hasSubstitutes() {
        return this.substitutes.length > 0;
    }

    public IBlockState[] getSubstitutes() {
        return this.substitutes;
    }

    public boolean isWildcard() {
        return this.wildcard;
    }

    public ItemStack[] transformToStack() {
        if (this.wildcard) {
            return new ItemStack[0];
        }
        ItemStack[] stacks = new ItemStack[this.substitutes.length + 1];
        stacks[0] = BlockStates.transformStateToStack(this.defaultBlockState);
        for (int i = 0; i < this.substitutes.length; ++i) {
            stacks[i + 1] = BlockStates.transformStateToStack(this.substitutes[i]);
        }
        return stacks;
    }

    public static ItemStack transformStateToStack(IBlockState state) {
        return new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
    }

    public static IBlockState transformStackToState(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (!(item instanceof ItemBlock)) {
            throw new IllegalArgumentException("[LabsDraconicEvolution] Stack's Item must extend ItemBlock!");
        }
        ItemBlock block = (ItemBlock)item;
        return block.func_179223_d().func_176203_a(stack.func_77960_j());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlockStates)) {
            return false;
        }
        BlockStates states = (BlockStates)obj;
        return states.isWildcard() && this.isWildcard() || BlockStates.statesEqual(states.getDefault(), this.getDefault());
    }

    public static boolean statesEqual(IBlockState a, IBlockState b) {
        return Objects.equals(a.func_177230_c().getRegistryName(), b.func_177230_c().getRegistryName()) && a.func_177230_c().func_176201_c(a) == b.func_177230_c().func_176201_c(b);
    }
}

