/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.integration.draconicevolution;

import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyStorageCore;
import com.nomiceu.nomilabs.NomiLabs;
import com.nomiceu.nomilabs.config.LabsConfig;
import com.nomiceu.nomilabs.gregtech.material.registry.LabsMaterials;
import com.nomiceu.nomilabs.integration.draconicevolution.BlockStateEnergyCoreStructure;
import com.nomiceu.nomilabs.integration.draconicevolution.BlockStateMultiblockStorage;
import com.nomiceu.nomilabs.integration.draconicevolution.BlockStates;
import gregtech.api.GregTechAPI;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.common.blocks.BlockCompressed;
import gregtech.common.blocks.MetaBlocks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class DraconicHelpers {
    private static List<ItemStack> gtDraconiumCache;
    private static List<ItemStack> gtAwakenedCache;
    private static final int DRACONIC_NUGGET_META = 0;
    private static final int AWAKENED_NUGGET_META = 1;
    private static final int COUNT = 1;
    private static final int INSTANT_SPEED = 0;

    public static List<ItemStack> getGTDraconium() {
        if (gtDraconiumCache != null) {
            return gtDraconiumCache;
        }
        List<ItemStack> materialList = DraconicHelpers.getListFromMaterial(LabsMaterials.Draconium, "draconium");
        if (materialList == null) {
            List<ItemStack> gtDraconium = DraconicHelpers.getDefaultDraconium();
            gtDraconiumCache = gtDraconium.stream().map(ItemStack::func_77946_l).collect(Collectors.toList());
            return gtDraconium;
        }
        gtDraconiumCache = materialList.stream().map(ItemStack::func_77946_l).collect(Collectors.toList());
        return materialList;
    }

    public static List<ItemStack> getGTAwakenedDraconium() {
        if (gtAwakenedCache != null) {
            return gtAwakenedCache;
        }
        List<ItemStack> materialList = DraconicHelpers.getListFromMaterial(LabsMaterials.AwakenedDraconium, "awakened_draconium");
        if (materialList == null) {
            List<ItemStack> gtAwakenedDraconium = DraconicHelpers.getDefaultAwakened();
            gtAwakenedCache = gtAwakenedDraconium.stream().map(ItemStack::func_77946_l).collect(Collectors.toList());
            return gtAwakenedDraconium;
        }
        gtAwakenedCache = materialList.stream().map(ItemStack::func_77946_l).collect(Collectors.toList());
        return materialList;
    }

    public static List<ItemStack> getDefaultDraconium() {
        ArrayList<ItemStack> gtDraconium = new ArrayList<ItemStack>();
        gtDraconium.add(new ItemStack((Block)DEFeatures.draconiumBlock, 1));
        gtDraconium.add(new ItemStack(DEFeatures.draconiumIngot, 1));
        gtDraconium.add(new ItemStack((Item)DEFeatures.nugget, 1, 0));
        return gtDraconium;
    }

    public static List<ItemStack> getDefaultAwakened() {
        ArrayList<ItemStack> gtAwakenedDraconium = new ArrayList<ItemStack>();
        gtAwakenedDraconium.add(new ItemStack((Block)DEFeatures.draconicBlock, 1));
        gtAwakenedDraconium.add(new ItemStack(DEFeatures.draconicIngot, 1));
        gtAwakenedDraconium.add(new ItemStack((Item)DEFeatures.nugget, 1, 1));
        return gtAwakenedDraconium;
    }

    @Nullable
    private static List<ItemStack> getListFromMaterial(@Nullable Material nomiLabsDeclaration, @NotNull String materialName) {
        Material material;
        ArrayList<ItemStack> materialList = new ArrayList<ItemStack>();
        if (LabsConfig.content.gtCustomContent.enableMaterials && nomiLabsDeclaration != null) {
            material = nomiLabsDeclaration;
        } else {
            material = GregTechAPI.materialManager.getMaterial(materialName);
            if (material == null) {
                NomiLabs.LOGGER.fatal("No GT material with name '" + materialName + "' for use in Nomi Labs Draconic Evolution Integration, and custom GT content has not been enabled! Defaulting to normal Draconic Evolution Draconium...");
                return null;
            }
        }
        IBlockState gtDraconiumState = ((BlockCompressed)MetaBlocks.COMPRESSED.get(material)).getBlock(material);
        materialList.add(new ItemStack(gtDraconiumState.func_177230_c(), 1, gtDraconiumState.func_177230_c().func_176201_c(gtDraconiumState)));
        materialList.add(OreDictUnifier.get((OrePrefix)OrePrefix.ingot, (Material)material, (int)1));
        materialList.add(OreDictUnifier.get((OrePrefix)OrePrefix.nugget, (Material)material, (int)1));
        return materialList;
    }

    public static boolean extractItem(ItemStack toExtract, EntityPlayer player) {
        IItemHandler handler = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (handler == null) {
            return false;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack extracted;
            ItemStack inSlot = handler.getStackInSlot(i);
            if (inSlot.func_190926_b() || !inSlot.func_77973_b().equals(toExtract.func_77973_b()) || inSlot.func_77960_j() != toExtract.func_77960_j() || (extracted = handler.extractItem(i, 1, false)).func_190926_b() || !extracted.func_77973_b().equals(toExtract.func_77973_b()) || extracted.func_77960_j() != toExtract.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    public static boolean extractItemOfBlockStates(BlockStates toExtract, EntityPlayer player) {
        ItemStack[] extract;
        for (ItemStack stack : extract = toExtract.transformToStack()) {
            if (!DraconicHelpers.extractItem(stack, player)) continue;
            return true;
        }
        return false;
    }

    public static boolean insertItem(ItemStack toInsert, EntityPlayer player) {
        IItemHandler handler = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (handler == null) {
            return false;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack inserted;
            ItemStack inSlot = handler.getStackInSlot(i);
            if (!inSlot.func_190926_b() && (!inSlot.func_77973_b().equals(toInsert.func_77973_b()) || inSlot.func_77960_j() != toInsert.func_77960_j() || inSlot.func_190916_E() >= toInsert.func_77976_d()) || !(inserted = handler.insertItem(i, toInsert, false)).func_190926_b() && !inserted.func_77973_b().equals(Items.field_190931_a)) continue;
            return true;
        }
        return false;
    }

    public static boolean validState(BlockStates allowedStates, IBlockState state, boolean wildCardAir) {
        if (allowedStates.isWildcard()) {
            if (wildCardAir) {
                return state.func_177230_c().equals(Blocks.field_150350_a);
            }
            return true;
        }
        if (BlockStates.statesEqual(allowedStates.getDefault(), state)) {
            return true;
        }
        if (!allowedStates.hasSubstitutes()) {
            return false;
        }
        for (IBlockState substitute : allowedStates.getSubstitutes()) {
            if (!BlockStates.statesEqual(substitute, state)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static Map<BlockPos, BlockStates> getStructureBlocks(TileEnergyStorageCore core) {
        BlockStateEnergyCoreStructure structure = (BlockStateEnergyCoreStructure)core.coreStructure;
        BlockStateMultiblockStorage storage = structure.getStorageForTier(core.tier.value);
        BlockPos start = core.func_174877_v().func_177971_a((Vec3i)structure.getCoreOffset(core.tier.value));
        HashMap<BlockPos, BlockStates> structureBlocks = new HashMap<BlockPos, BlockStates>();
        storage.forEachBlockStates(start, structureBlocks::put);
        return structureBlocks;
    }

    public static boolean instantBuilder() {
        return LabsConfig.modIntegration.draconicEvolutionIntegration.autoBuilderSpeed == 0;
    }

    public static boolean instantDestructor() {
        return LabsConfig.modIntegration.draconicEvolutionIntegration.autoDestructorSpeed == 0;
    }
}

