/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.integration.draconicevolution;

import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyStorageCore;
import com.nomiceu.nomilabs.config.LabsConfig;
import com.nomiceu.nomilabs.integration.draconicevolution.BlockStates;
import com.nomiceu.nomilabs.integration.draconicevolution.DraconicHelpers;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class EnergyCoreBuilderLogic {
    public static boolean build(TileEnergyStorageCore core, EntityPlayer player, Map<BlockPos, BlockStates> workList, LinkedList<BlockPos> workOrder) {
        workList.clear();
        workOrder.clear();
        if (EnergyCoreBuilderLogic.buildWorklist(core, player, workList, workOrder)) {
            workList.clear();
            return true;
        }
        if (DraconicHelpers.instantBuilder()) {
            EnergyCoreBuilderLogic.buildInstant(core.func_145831_w(), player, workList, workOrder);
            return true;
        }
        return false;
    }

    private static boolean buildWorklist(TileEnergyStorageCore core, EntityPlayer player, Map<BlockPos, BlockStates> workList, LinkedList<BlockPos> workOrder) {
        Map<BlockPos, BlockStates> structureBlocks = DraconicHelpers.getStructureBlocks(core);
        World world = core.func_145831_w();
        for (BlockPos key : structureBlocks.keySet()) {
            BlockStates neededStates = structureBlocks.get(key);
            if (world.func_175623_d(key)) {
                workList.put(key, neededStates);
                continue;
            }
            IBlockState state = world.func_180495_p(key);
            if (DraconicHelpers.validState(neededStates, state, false)) continue;
            player.func_145747_a(new TextComponentTranslation("ecore.de.assemble_found_invalid.txt", new Object[]{BlockStates.transformStateToStack(state).func_82833_r(), key.toString()}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            return true;
        }
        workOrder.addAll(workList.keySet());
        workOrder.sort(Comparator.comparingDouble(value -> value.func_177951_i((Vec3i)core.func_174877_v())));
        return false;
    }

    private static void buildInstant(World world, EntityPlayer player, Map<BlockPos, BlockStates> workList, LinkedList<BlockPos> workOrder) {
        boolean isDead = false;
        while (!isDead) {
            isDead = EnergyCoreBuilderLogic.updateProcess(world, player, workList, workOrder);
        }
    }

    public static boolean updateBuildProcess(World world, EntityPlayer player, Map<BlockPos, BlockStates> workList, LinkedList<BlockPos> workOrder) {
        for (int i = 0; i < LabsConfig.modIntegration.draconicEvolutionIntegration.autoBuilderSpeed; ++i) {
            if (!EnergyCoreBuilderLogic.updateProcess(world, player, workList, workOrder)) continue;
            return true;
        }
        return false;
    }

    private static boolean updateProcess(World world, EntityPlayer player, Map<BlockPos, BlockStates> workList, LinkedList<BlockPos> workOrder) {
        if (workOrder.isEmpty() || player.field_70128_L) {
            return true;
        }
        BlockPos pos = workOrder.poll();
        BlockStates states = workList.get(pos);
        if (!world.func_175623_d(pos)) {
            if (DraconicHelpers.validState(states, world.func_180495_p(pos), false)) {
                return false;
            }
            player.func_145747_a(new TextComponentTranslation("ecore.de.assemble_error_expected_air.txt", new Object[]{pos.toString()}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            return true;
        }
        if (!player.field_71075_bZ.field_75098_d && !DraconicHelpers.extractItemOfBlockStates(states, player)) {
            ItemStack[] requiredStacks = states.transformToStack();
            String required = String.join((CharSequence)", OR ", (CharSequence[])Arrays.stream(requiredStacks).map(ItemStack::func_82833_r).toArray(String[]::new));
            player.func_145747_a(new TextComponentTranslation("ecore.de.assemble_missing_required_new.txt", new Object[]{required}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            return true;
        }
        world.func_175656_a(pos, states.getDefault());
        SoundType soundtype = states.getDefault().func_177230_c().getSoundType(states.getDefault(), world, pos, (Entity)player);
        world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        return false;
    }
}

