/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.integration.draconicevolution;

import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyStorageCore;
import com.nomiceu.nomilabs.config.LabsConfig;
import com.nomiceu.nomilabs.integration.draconicevolution.BlockStateEnergyCoreStructure;
import com.nomiceu.nomilabs.integration.draconicevolution.BlockStates;
import com.nomiceu.nomilabs.integration.draconicevolution.DraconicHelpers;
import com.nomiceu.nomilabs.integration.draconicevolution.StoppableProcess;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class EnergyCoreDestructor
implements StoppableProcess {
    private Map<BlockPos, BlockStates> workList = new HashMap<BlockPos, BlockStates>();
    private final LinkedList<BlockPos> workOrder = new LinkedList();
    private final TileEnergyStorageCore core;
    private final EntityPlayer player;
    private boolean isDead = false;
    private final World world;

    public EnergyCoreDestructor(TileEnergyStorageCore core, EntityPlayer player) {
        this.player = player;
        this.core = core;
        this.world = core.func_145831_w();
        this.destruct();
    }

    private void destruct() {
        this.workList.clear();
        this.workOrder.clear();
        this.buildWorklist();
        if (DraconicHelpers.instantDestructor()) {
            this.destructInstant();
        }
    }

    private void buildWorklist() {
        this.workList = DraconicHelpers.getStructureBlocks(this.core);
        this.workOrder.addAll(this.workList.keySet());
        this.workOrder.sort(Comparator.comparingDouble(value -> ((BlockPos)value).func_177951_i((Vec3i)this.core.func_174877_v())).reversed());
    }

    private void destructInstant() {
        while (!this.isDead) {
            this.updateProcess();
        }
    }

    public void updateDestructProcess() {
        for (int i = 0; i < LabsConfig.modIntegration.draconicEvolutionIntegration.autoDestructorSpeed; ++i) {
            this.updateProcess();
            if (!this.isDead) continue;
            return;
        }
    }

    private void updateProcess() {
        ItemStack stack;
        if (this.workOrder.isEmpty() || this.player.field_70128_L) {
            this.stop();
        }
        BlockPos pos = this.workOrder.poll();
        BlockStates states = this.workList.get(pos);
        if (pos == null || states == null) {
            return;
        }
        if (states.isWildcard() || states.equals(((BlockStateEnergyCoreStructure)this.core.coreStructure).X) || this.world.func_175623_d(pos)) {
            return;
        }
        if (!this.player.field_71075_bZ.field_75098_d && !DraconicHelpers.insertItem(stack = new ItemStack(states.getDefault().func_177230_c(), 1, states.getDefault().func_177230_c().func_176201_c(states.getDefault())), this.player)) {
            Block.func_180635_a((World)this.world, (BlockPos)pos, (ItemStack)stack);
        }
        this.world.func_175698_g(pos);
        SoundType soundtype = states.getDefault().func_177230_c().getSoundType(states.getDefault(), this.world, pos, (Entity)this.player);
        this.world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, soundtype.func_185845_c(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
    }

    @Override
    public void stop() {
        this.isDead = true;
        this.workOrder.clear();
        this.workList.clear();
    }

    public boolean isDead() {
        return this.isDead;
    }
}

