/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.integration.effortlessbuilding;

import com.google.common.collect.ImmutableMap;
import com.nomiceu.nomilabs.config.LabsConfig;
import com.nomiceu.nomilabs.util.LabsTranslate;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import nl.requios.effortlessbuilding.BuildConfig;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;

public class GenericReachUpgrade {
    public static final int CREATIVE_LEVEL = -1;
    public static Map<Integer, ReachInfo> REACH_MAP = ImmutableMap.of((Object)-1, (Object)new ReachInfo(() -> BuildConfig.reach.maxReachCreative, () -> LabsConfig.modIntegration.effortlessBuildingIntegration.axisReachCreative, () -> LabsConfig.modIntegration.effortlessBuildingIntegration.blocksPlacedCreative), (Object)0, (Object)new ReachInfo(() -> BuildConfig.reach.maxReachLevel0, () -> LabsConfig.modIntegration.effortlessBuildingIntegration.axisReach0, () -> LabsConfig.modIntegration.effortlessBuildingIntegration.blocksPlaced0), (Object)1, (Object)new ReachInfo(() -> BuildConfig.reach.maxReachLevel1, () -> LabsConfig.modIntegration.effortlessBuildingIntegration.axisReach1, () -> LabsConfig.modIntegration.effortlessBuildingIntegration.blocksPlaced1), (Object)2, (Object)new ReachInfo(() -> BuildConfig.reach.maxReachLevel2, () -> LabsConfig.modIntegration.effortlessBuildingIntegration.axisReach2, () -> LabsConfig.modIntegration.effortlessBuildingIntegration.blocksPlaced2), (Object)3, (Object)new ReachInfo(() -> BuildConfig.reach.maxReachLevel3, () -> LabsConfig.modIntegration.effortlessBuildingIntegration.axisReach3, () -> LabsConfig.modIntegration.effortlessBuildingIntegration.blocksPlaced3));

    public static ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand, int upgradeLevel) {
        if (player.func_184812_l_()) {
            if (world.field_72995_K) {
                EffortlessBuilding.log((EntityPlayer)player, (String)LabsTranslate.translate("effortlessbuilding.use.reach_upgrade.creative.1", new Object[0]));
                EffortlessBuilding.log((EntityPlayer)player, (String)LabsTranslate.translate("effortlessbuilding.use.reach_upgrade.creative.2", new Object[0]));
            }
            return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
        }
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings((EntityPlayer)player);
        int currentLevel = modifierSettings.getReachUpgrade();
        if (currentLevel < upgradeLevel - 1 && currentLevel >= 0 && world.field_72995_K) {
            EffortlessBuilding.log((EntityPlayer)player, (String)LabsTranslate.translate("effortlessbuilding.use.reach_upgrade.previous", upgradeLevel - 1));
        }
        if (currentLevel == upgradeLevel - 1) {
            ReachInfo currentReach = REACH_MAP.get(upgradeLevel - 1);
            ReachInfo newReach = REACH_MAP.get(upgradeLevel);
            modifierSettings.setReachUpgrade(upgradeLevel);
            if (world.field_72995_K) {
                EffortlessBuilding.log((EntityPlayer)player, (String)LabsTranslate.translate("effortlessbuilding.use.reach_upgrade.success.1", new Object[0]));
                EffortlessBuilding.log((EntityPlayer)player, (String)LabsTranslate.translate("effortlessbuilding.use.reach_upgrade.success.2", currentReach.getAxis(), newReach.getAxis()));
                EffortlessBuilding.log((EntityPlayer)player, (String)LabsTranslate.translate("effortlessbuilding.use.reach_upgrade.success.3", currentReach.getDistance(), newReach.getDistance()));
            }
            player.func_184611_a(hand, ItemStack.field_190927_a);
            SoundEvent soundEvent = new SoundEvent(new ResourceLocation("entity.player.levelup"));
            player.func_184185_a(soundEvent, 1.0f, 1.0f);
            return new ActionResult(EnumActionResult.PASS, (Object)ItemStack.field_190927_a);
        }
        if (currentLevel > upgradeLevel - 1 && world.field_72995_K) {
            EffortlessBuilding.log((EntityPlayer)player, (String)LabsTranslate.translate("effortlessbuilding.use.reach_upgrade.already_used", new Object[0]));
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
    }

    public static void addInformation(List<String> tooltip, int level) {
        ReachInfo reach = REACH_MAP.get(level);
        tooltip.add(LabsTranslate.translate("effortlessbuilding.item.reach_upgrade.tooltip.1", new Object[0]));
        tooltip.add(LabsTranslate.translate("effortlessbuilding.item.reach_upgrade.tooltip.2", reach.getAxis()));
        tooltip.add(LabsTranslate.translate("effortlessbuilding.item.reach_upgrade.tooltip.3", reach.getDistance()));
    }

    public static class ReachInfo {
        private final Supplier<Integer> distance;
        private final Supplier<Integer> axis;
        private final Supplier<Integer> maxBlocks;

        public ReachInfo(Supplier<Integer> distance, Supplier<Integer> axis, Supplier<Integer> maxBlocks) {
            this.distance = distance;
            this.axis = axis;
            this.maxBlocks = maxBlocks;
        }

        public int getDistance() {
            return this.distance.get();
        }

        public int getAxis() {
            return this.axis.get();
        }

        public int getMaxBlocks() {
            return this.maxBlocks.get();
        }
    }
}

