/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.integration.ftbutilities;

import com.feed_the_beast.ftbutilities.data.ClaimedChunk;
import com.feed_the_beast.ftbutilities.data.ClaimedChunks;
import com.nomiceu.nomilabs.NomiLabs;
import com.nomiceu.nomilabs.integration.ftbutilities.network.CanEditChunkDataMessage;
import com.nomiceu.nomilabs.network.LabsNetworkHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.Nullable;

public class CanEditChunkDataMessageHelper {
    public static void sendMessageToAll() {
        if (!ClaimedChunks.isActive()) {
            return;
        }
        MinecraftServer server = CanEditChunkDataMessageHelper.getUniverseServer();
        if (server == null) {
            return;
        }
        for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
            CanEditChunkDataMessageHelper.sendMessage(player);
        }
    }

    public static void sendMessage(EntityPlayerMP player) {
        int chunkX = MathHelper.func_76128_c((double)player.field_70165_t) >> 4;
        int chunkZ = MathHelper.func_76128_c((double)player.field_70161_v) >> 4;
        int startX = chunkX - 2;
        int startZ = chunkZ - 2;
        int dim = player.field_70170_p.field_73011_w.getDimension();
        boolean[] storage = new boolean[25];
        for (int x = 0; x < 5; ++x) {
            for (int z = 0; z < 5; ++z) {
                storage[x * 5 + z] = !CanEditChunkDataMessageHelper.playerCanEdit(startX + x, startZ + z, dim, player);
            }
        }
        LabsNetworkHandler.NETWORK_HANDLER.sendTo((IMessage)new CanEditChunkDataMessage(startX, startZ, storage), player);
        NomiLabs.LOGGER.debug("[FTB Utils Integration] Sent CanEditChunkDataMessage to Player {} ({})", (Object)player.func_110124_au(), (Object)player.func_70005_c_());
    }

    private static boolean playerCanEdit(int posX, int posZ, int dim, EntityPlayerMP player) {
        ClaimedChunk chunk = CanEditChunkDataMessageHelper.getChunk(posX, posZ, dim);
        Object forgePlayer = CanEditChunkDataMessageHelper.getUniversePlayer(player);
        if (chunk == null || forgePlayer == null) {
            return true;
        }
        try {
            Method getTeamMethod = chunk.getClass().getDeclaredMethod("getTeam", new Class[0]);
            Object team = getTeamMethod.invoke((Object)chunk, new Object[0]);
            Method getDataMethod = chunk.getClass().getDeclaredMethod("getData", new Class[0]);
            Object data = getDataMethod.invoke((Object)chunk, new Object[0]);
            Method getStatusMethod = data.getClass().getDeclaredMethod("getEditBlocksStatus", new Class[0]);
            Object status = getStatusMethod.invoke(data, new Object[0]);
            Method hasStatusMethod = team.getClass().getDeclaredMethod("hasStatus", forgePlayer.getClass(), status.getClass());
            return (Boolean)hasStatusMethod.invoke(team, forgePlayer, status);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            NomiLabs.LOGGER.fatal("[FTB Utils Integration] Failed to Check whether Player {} can edit at posX {}, posZ {}, dim {}! See Exception Below!", (Object)player.func_110124_au(), (Object)posX, (Object)posZ, (Object)dim);
            NomiLabs.LOGGER.throwing(Level.FATAL, (Throwable)e);
            return true;
        }
    }

    @Nullable
    private static Object getUniversePlayer(EntityPlayerMP player) {
        Object universe = CanEditChunkDataMessageHelper.getUniverse();
        if (universe == null) {
            return null;
        }
        try {
            Method forgePlayerMethod = universe.getClass().getDeclaredMethod("getPlayer", UUID.class);
            return forgePlayerMethod.invoke(universe, player.func_110124_au());
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            NomiLabs.LOGGER.fatal("[FTB Utils Integration] Failed to get Universe Player! See Exception Below!");
            NomiLabs.LOGGER.throwing(Level.FATAL, (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static MinecraftServer getUniverseServer() {
        Object universe = CanEditChunkDataMessageHelper.getUniverse();
        if (universe == null) {
            return null;
        }
        try {
            Field serverField = universe.getClass().getDeclaredField("server");
            return (MinecraftServer)serverField.get(universe);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            NomiLabs.LOGGER.fatal("[FTB Utils Integration] Failed to get Universe Server! See Exception Below!");
            NomiLabs.LOGGER.throwing(Level.FATAL, (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static Object getUniverse() {
        try {
            ClaimedChunks instance = ClaimedChunks.instance;
            Field universeField = instance.getClass().getDeclaredField("universe");
            return universeField.get(instance);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            NomiLabs.LOGGER.fatal("[FTB Utils Integration] Failed to get Universe! See Exception Below!");
            NomiLabs.LOGGER.throwing(Level.FATAL, (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static ClaimedChunk getChunk(int posX, int posZ, int dim) {
        try {
            Class<?> chunkDimPosClass = Class.forName("com.feed_the_beast.ftblib.lib.math.ChunkDimPos");
            Constructor<?> constructor = chunkDimPosClass.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
            Object obj = constructor.newInstance(posX, posZ, dim);
            Class<?> claimedChunksClass = Class.forName("com.feed_the_beast.ftbutilities.data.ClaimedChunks");
            Method getChunkMethod = claimedChunksClass.getDeclaredMethod("getChunk", chunkDimPosClass);
            return (ClaimedChunk)getChunkMethod.invoke((Object)ClaimedChunks.instance, chunkDimPosClass.cast(obj));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            NomiLabs.LOGGER.fatal("[FTB Utils Integration] Failed to get Chunk with posX {}, posZ {}, dim {}! See Exception Below!", (Object)posX, (Object)posZ, (Object)dim);
            NomiLabs.LOGGER.throwing(Level.FATAL, (Throwable)e);
            return null;
        }
    }
}

