/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.integration.ftbutilities;

import com.feed_the_beast.ftbutilities.FTBUtilitiesPermissions;
import com.feed_the_beast.ftbutilities.data.ClaimedChunks;
import com.nomiceu.nomilabs.NomiLabs;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;

public class CanEditChunkHelper {
    private static final Map<ChunkPos, Boolean> cannotEditChunks = new Object2ObjectOpenHashMap();

    public static void clear() {
        cannotEditChunks.clear();
    }

    public static void addEntries(boolean[][] entries, int startX, int startZ) {
        for (int x = 0; x < entries.length; ++x) {
            for (int z = 0; z < entries[x].length; ++z) {
                cannotEditChunks.put(new ChunkPos(startX + x, startZ + z), entries[x][z]);
            }
        }
        NomiLabs.LOGGER.debug("[FTB Utils Integration] Chunk Editing Permissions: {}", cannotEditChunks.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((ChunkPos)entry.getKey()).field_77276_a).thenComparingInt(entry -> ((ChunkPos)entry.getKey()).field_77275_b)).map(entry -> "chunk: x: " + ((ChunkPos)entry.getKey()).field_77276_a + ", z: " + ((ChunkPos)entry.getKey()).field_77275_b + " | " + entry.getValue()).collect(Collectors.toList()));
    }

    public static boolean cannotEditChunk(EntityPlayer player, BlockPos pos, IBlockState state) {
        if (player.field_70170_p == null) {
            return false;
        }
        ChunkPos chunkPos = new ChunkPos(pos);
        Boolean editable = cannotEditChunks.get(chunkPos);
        if (player instanceof EntityPlayerMP && ClaimedChunks.isActive() || editable == null) {
            return ClaimedChunks.blockBlockEditing((EntityPlayer)player, (BlockPos)pos, (IBlockState)state);
        }
        if (state == null) {
            state = player.field_70170_p.func_180495_p(pos);
        }
        return !FTBUtilitiesPermissions.hasBlockEditingPermission((EntityPlayer)player, (Block)state.func_177230_c()) && editable != false;
    }
}

