/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.integration.ftbutilities.network;

import com.nomiceu.nomilabs.NomiLabs;
import com.nomiceu.nomilabs.integration.ftbutilities.CanEditChunkHelper;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class CanEditChunkDataMessage
implements IMessage {
    private int startX;
    private int startZ;
    private int storage;
    public static final int STORAGE_LENGTH = 25;
    public static final int STORAGE_WIDTH = 5;

    public CanEditChunkDataMessage() {
        this.startX = 0;
        this.startZ = 0;
        this.storage = 0;
    }

    public CanEditChunkDataMessage(int startX, int startZ, boolean[] chunkInfo) {
        if (chunkInfo.length != 25) {
            throw new RuntimeException("[FTB Utils Integration] Chunk Info cannot have length that is not 25!");
        }
        this.startX = startX;
        this.startZ = startZ;
        this.storage = 0;
        NomiLabs.LOGGER.debug("[FTB Utils Integration] Serializing Chunk Info {}...", (Object)chunkInfo);
        for (int i = 0; i < chunkInfo.length; ++i) {
            if (!chunkInfo[i]) continue;
            this.storage += 1 << i;
        }
        NomiLabs.LOGGER.debug("[FTB Utils Integration] Made CanEditChunkDataMessage with Storage {} with start x {} and start z {}", (Object)this.storage, (Object)startX, (Object)startZ);
    }

    public boolean[][] getChunkInfo() {
        NomiLabs.LOGGER.debug("[FTB Utils Integration] Decoding Storage {}...", (Object)this.storage);
        boolean[][] chunkInfo = new boolean[5][5];
        for (int x = 0; x < 5; ++x) {
            for (int z = 0; z < 5; ++z) {
                chunkInfo[x][z] = (this.storage >> x * 5 + z & 1) != 0;
            }
        }
        NomiLabs.LOGGER.debug("[FTB Utils Integration] Decoded Storage into Chunk Info: {}", (Object)Arrays.deepToString((Object[])chunkInfo));
        return chunkInfo;
    }

    public int getStartX() {
        return this.startX;
    }

    public int getStartZ() {
        return this.startZ;
    }

    public void fromBytes(ByteBuf buf) {
        this.storage = buf.readInt();
        this.startX = buf.readInt();
        this.startZ = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.storage);
        buf.writeInt(this.startX);
        buf.writeInt(this.startZ);
    }

    public static class MessageHandler
    implements IMessageHandler<CanEditChunkDataMessage, IMessage> {
        public IMessage onMessage(CanEditChunkDataMessage message, MessageContext ctx) {
            if (!ctx.side.isClient()) {
                return null;
            }
            NomiLabs.LOGGER.debug("[FTB Utils Integration] Received CanEditChunkDataMessage with Storage {} with start x {} and start z {}", (Object)message.storage, (Object)message.startX, (Object)message.startZ);
            CanEditChunkHelper.clear();
            CanEditChunkHelper.addEntries(message.getChunkInfo(), message.getStartX(), message.getStartZ());
            return null;
        }
    }
}

