/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.integration.jei;

import com.cleanroommc.groovyscript.api.GroovyBlacklist;
import com.cleanroommc.groovyscript.api.GroovyLog;
import com.cleanroommc.groovyscript.registry.ReloadableRegistryManager;
import com.google.common.collect.ImmutableList;
import com.nomiceu.nomilabs.groovy.PartialRecipe;
import com.nomiceu.nomilabs.groovy.mixinhelper.LabsJEIApplied;
import com.nomiceu.nomilabs.integration.jei.PartialRecipeWrapper;
import com.nomiceu.nomilabs.integration.jei.mixinhelper.AccessibleModRegistry;
import com.nomiceu.nomilabs.item.registry.LabsItems;
import com.nomiceu.nomilabs.util.ItemTagMeta;
import com.nomiceu.nomilabs.util.LabsTranslate;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.VanillaTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

@GroovyBlacklist
@JEIPlugin
public class LabsJEIPlugin
implements IModPlugin {
    private static final ResourceLocation WILDCARD_LOCATION = new ResourceLocation("*", "*");
    private static final Map<ItemTagMeta, List<LabsTranslate.Translatable>> DESCRIPTIONS = new HashMap<ItemTagMeta, List<LabsTranslate.Translatable>>();
    private static final Map<ItemTagMeta, List<LabsTranslate.Translatable>> GROOVY_DESCRIPTIONS = new HashMap<ItemTagMeta, List<LabsTranslate.Translatable>>();
    private static final Map<ResourceLocation, List<LabsTranslate.Translatable>> RECIPE_OUTPUT_TOOLTIPS = new Object2ObjectOpenHashMap();
    private static final Map<ResourceLocation, List<LabsTranslate.Translatable>> GROOVY_RECIPE_OUTPUT_TOOLTIPS = new Object2ObjectOpenHashMap();
    private static Map<ResourceLocation, List<LabsTranslate.Translatable>> COMPILED_RECIPE_OUTPUT_TOOLTIPS = null;
    private static final Map<ResourceLocation, List<LabsTranslate.Translatable>[]> RECIPE_INPUT_TOOLTIPS = new Object2ObjectOpenHashMap();
    private static final Map<ResourceLocation, List<LabsTranslate.Translatable>[]> GROOVY_RECIPE_INPUT_TOOLTIPS = new Object2ObjectOpenHashMap();
    private static Map<ResourceLocation, List<LabsTranslate.Translatable>[]> COMPILED_RECIPE_INPUT_TOOLTIPS = null;
    private static final List<Pair<ItemStack, Function<NBTTagCompound, Boolean>>> IGNORE_NBT_HIDE = new ArrayList<Pair<ItemStack, Function<NBTTagCompound, Boolean>>>();
    private static final Map<String, List<Object>> CATALYST_OVERRIDE = new Object2ObjectOpenHashMap();
    private static IIngredientRegistry itemRegistry;

    public void register(IModRegistry registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        itemRegistry = registry.getIngredientRegistry();
        registry.handleRecipes(PartialRecipe.class, recipe -> new PartialRecipeWrapper(jeiHelpers, (PartialRecipe)((Object)recipe)), "minecraft.crafting");
        HashMap<ItemTagMeta, List<LabsTranslate.Translatable>> tempMap = new HashMap<ItemTagMeta, List<LabsTranslate.Translatable>>(DESCRIPTIONS);
        GROOVY_DESCRIPTIONS.forEach((key, value) -> LabsJEIPlugin.addDescription(tempMap, key, (List<LabsTranslate.Translatable> list) -> list.addAll(value)));
        tempMap.forEach((itemTagMeta, strings) -> registry.addIngredientInfo((Object)itemTagMeta.toStack(), VanillaTypes.ITEM, new String[]{strings.stream().map(LabsTranslate.Translatable::translate).collect(Collectors.joining("\n\n"))}));
        LabsJEIApplied.afterRegisterApplied = false;
    }

    public static void afterModRegisters(IModRegistry registry) {
        for (Map.Entry<String, List<Object>> override : CATALYST_OVERRIDE.entrySet()) {
            ((AccessibleModRegistry)registry).labs$replaceRecipeCatalyst(override.getKey(), override.getValue());
        }
    }

    public void onRuntimeAvailable(@NotNull IJeiRuntime jeiRuntime) {
        itemRegistry.removeIngredientsAtRuntime(VanillaTypes.ITEM, Collections.singletonList(new ItemStack((Item)LabsItems.INFO_ITEM)));
        LabsJEIApplied.afterRuntimeApplied = false;
    }

    public static void hideItemNBTMatch(ItemStack itemStack, Function<NBTTagCompound, Boolean> condition) {
        IGNORE_NBT_HIDE.add((Pair<ItemStack, Function<NBTTagCompound, Boolean>>)Pair.of((Object)itemStack, condition));
    }

    public static void removeAndHideItemNBTMatch(ItemStack itemStack, Function<NBTTagCompound, Boolean> condition) {
        for (IRecipe recipe : ForgeRegistries.RECIPES) {
            ItemStack output = recipe.func_77571_b();
            if (recipe.getRegistryName() == null || output.func_77973_b() != itemStack.func_77973_b() || output.func_77960_j() != itemStack.func_77960_j() || !condition.apply(output.func_77978_p()).booleanValue()) continue;
            ReloadableRegistryManager.removeRegistryEntry((IForgeRegistry)ForgeRegistries.RECIPES, (ResourceLocation)recipe.getRegistryName());
        }
        IGNORE_NBT_HIDE.add((Pair<ItemStack, Function<NBTTagCompound, Boolean>>)Pair.of((Object)itemStack, condition));
    }

    public static List<Pair<ItemStack, Function<NBTTagCompound, Boolean>>> getIgnoreNbtHide() {
        return ImmutableList.copyOf(IGNORE_NBT_HIDE);
    }

    public static void addDescription(@NotNull ItemStack stack, LabsTranslate.Translatable ... description) {
        LabsJEIPlugin.addDescription(DESCRIPTIONS, new ItemTagMeta(stack), (List<LabsTranslate.Translatable> list) -> Collections.addAll(list, description));
    }

    public static void addGroovyDescription(@NotNull ItemStack stack, LabsTranslate.Translatable ... description) {
        LabsJEIPlugin.addDescription(GROOVY_DESCRIPTIONS, new ItemTagMeta(stack), (List<LabsTranslate.Translatable> list) -> Collections.addAll(list, description));
    }

    private static void addDescription(Map<ItemTagMeta, List<LabsTranslate.Translatable>> map, @NotNull ItemTagMeta stack, Consumer<List<LabsTranslate.Translatable>> addToList) {
        map.computeIfAbsent(stack, k -> new ArrayList());
        addToList.accept(map.get(stack));
    }

    public static void addRecipeOutputTooltip(ResourceLocation recipeName, LabsTranslate.Translatable ... tooltip) {
        LabsJEIPlugin.addRecipeOutputTooltip(RECIPE_OUTPUT_TOOLTIPS, recipeName, (List<LabsTranslate.Translatable> list) -> Collections.addAll(list, tooltip));
    }

    public static void addGroovyRecipeOutputTooltip(ResourceLocation recipeName, LabsTranslate.Translatable ... tooltip) {
        LabsJEIPlugin.addRecipeOutputTooltip(GROOVY_RECIPE_OUTPUT_TOOLTIPS, recipeName, (List<LabsTranslate.Translatable> list) -> Collections.addAll(list, tooltip));
    }

    private static void addRecipeOutputTooltip(Map<ResourceLocation, List<LabsTranslate.Translatable>> map, ResourceLocation recipeName, Consumer<List<LabsTranslate.Translatable>> addToList) {
        addToList.accept(map.computeIfAbsent(recipeName, k -> new ArrayList()));
    }

    private static void cacheRecipeOutputTooltip() {
        if (COMPILED_RECIPE_OUTPUT_TOOLTIPS != null) {
            return;
        }
        COMPILED_RECIPE_OUTPUT_TOOLTIPS = new Object2ObjectOpenHashMap(RECIPE_OUTPUT_TOOLTIPS);
        GROOVY_RECIPE_OUTPUT_TOOLTIPS.forEach((key, value) -> LabsJEIPlugin.addRecipeOutputTooltip(COMPILED_RECIPE_OUTPUT_TOOLTIPS, Objects.requireNonNull(key), (List<LabsTranslate.Translatable> list) -> list.addAll(value)));
    }

    public static List<String> getRecipeOutputTooltip(ResourceLocation recipeName) {
        LabsJEIPlugin.cacheRecipeOutputTooltip();
        List<LabsTranslate.Translatable> result = COMPILED_RECIPE_OUTPUT_TOOLTIPS.get(recipeName);
        if (result == null) {
            return new ArrayList<String>();
        }
        return result.stream().map(LabsTranslate.Translatable::translate).collect(Collectors.toList());
    }

    public static void addRecipeInputTooltip(@NotNull ResourceLocation recipeName, int slotIndex, LabsTranslate.Translatable ... tooltip) {
        if (slotIndex < 0 || slotIndex > 8) {
            throw new IllegalArgumentException("Add Recipe Input Tooltip: Slot Index must be between 0 and 8!");
        }
        LabsJEIPlugin.addRecipeInputTooltip(RECIPE_INPUT_TOOLTIPS, recipeName, slotIndex, (List<LabsTranslate.Translatable> list) -> Collections.addAll(list, tooltip));
    }

    public static void addGroovyRecipeInputTooltip(@NotNull ResourceLocation recipeName, int slotIndex, LabsTranslate.Translatable ... tooltip) {
        if (slotIndex < 0 || slotIndex > 8) {
            GroovyLog.get().error((Object)"Add Recipe Input Tooltip: Slot Index must be between 0 and 8!");
            return;
        }
        LabsJEIPlugin.addRecipeInputTooltip(GROOVY_RECIPE_INPUT_TOOLTIPS, recipeName, slotIndex, (List<LabsTranslate.Translatable> list) -> Collections.addAll(list, tooltip));
    }

    private static void addRecipeInputTooltip(Map<ResourceLocation, List<LabsTranslate.Translatable>[]> map, @NotNull ResourceLocation recipeName, int slotIndex, Consumer<List<LabsTranslate.Translatable>> addToList) {
        List[] recipeTooltips = map.computeIfAbsent(recipeName, k -> new List[9]);
        ArrayList existingTranslations = recipeTooltips[slotIndex];
        if (existingTranslations == null) {
            existingTranslations = new ArrayList();
        }
        addToList.accept(existingTranslations);
        recipeTooltips[slotIndex] = existingTranslations;
    }

    private static void cacheRecipeInputTooltips() {
        if (COMPILED_RECIPE_INPUT_TOOLTIPS != null) {
            return;
        }
        COMPILED_RECIPE_INPUT_TOOLTIPS = new Object2ObjectOpenHashMap(RECIPE_INPUT_TOOLTIPS);
        GROOVY_RECIPE_INPUT_TOOLTIPS.forEach((key, value) -> {
            for (int i = 0; i < ((List[])value).length; ++i) {
                List tooltips = value[i];
                if (tooltips == null) continue;
                LabsJEIPlugin.addRecipeInputTooltip(COMPILED_RECIPE_INPUT_TOOLTIPS, key, i, (List<LabsTranslate.Translatable> list) -> list.addAll(tooltips));
            }
        });
    }

    public static List<String> getRecipeInputTooltip(ResourceLocation recipeName, int slotIndex) {
        LabsJEIPlugin.cacheRecipeInputTooltips();
        if (!COMPILED_RECIPE_INPUT_TOOLTIPS.containsKey(recipeName)) {
            return new ArrayList<String>();
        }
        List<LabsTranslate.Translatable> tooltips = COMPILED_RECIPE_INPUT_TOOLTIPS.get(recipeName)[slotIndex];
        if (tooltips == null) {
            return new ArrayList<String>();
        }
        return tooltips.stream().map(LabsTranslate.Translatable::translate).collect(Collectors.toList());
    }

    public static void addRecipeCatalystOverride(String category, Object ... catalyst) {
        ArrayList result = new ArrayList();
        Collections.addAll(result, catalyst);
        CATALYST_OVERRIDE.put(category, result);
    }

    public static void onReload() {
        GROOVY_DESCRIPTIONS.clear();
        GROOVY_RECIPE_OUTPUT_TOOLTIPS.clear();
        GROOVY_RECIPE_INPUT_TOOLTIPS.clear();
        IGNORE_NBT_HIDE.clear();
        CATALYST_OVERRIDE.clear();
        COMPILED_RECIPE_OUTPUT_TOOLTIPS = null;
        COMPILED_RECIPE_INPUT_TOOLTIPS = null;
    }
}

