/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.integration.nuclearcraft;

import com.nomiceu.nomilabs.NomiLabs;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.RecipeMaps;
import gregtech.common.items.MetaItems;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nc.config.NCConfig;
import nc.recipe.IRecipe;
import nc.recipe.ProcessorRecipe;
import nc.recipe.RecipeHelper;
import nc.recipe.ingredient.ChanceFluidIngredient;
import nc.recipe.ingredient.ChanceItemIngredient;
import nc.recipe.ingredient.IItemIngredient;
import nc.recipe.ingredient.OreIngredient;
import nc.util.NCUtil;
import nc.util.OreDictHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GTCEuRecipes {
    public static void addGTCEuRecipe(String recipeName, ProcessorRecipe recipe) {
        RecipeMap recipeMap = null;
        RecipeBuilder<?> builder = null;
        switch (recipeName) {
            case "manufactory": {
                recipeMap = RecipeMaps.MACERATOR_RECIPES;
                builder = GTCEuRecipes.addStats(recipeMap.recipeBuilder(), recipe, 12, 8);
                break;
            }
            case "isotope_separator": {
                recipeMap = RecipeMaps.THERMAL_CENTRIFUGE_RECIPES;
                builder = GTCEuRecipes.addStats(recipeMap.recipeBuilder(), recipe, 48, 160);
                break;
            }
            case "decay_hastener": 
            case "irradiator": {
                return;
            }
            case "fuel_reprocessor": {
                recipeMap = RecipeMaps.CENTRIFUGE_RECIPES;
                builder = GTCEuRecipes.addStats(recipeMap.recipeBuilder(), recipe, 24, 60);
                break;
            }
            case "alloy_furnace": {
                recipeMap = RecipeMaps.ALLOY_SMELTER_RECIPES;
                builder = GTCEuRecipes.addStats(recipeMap.recipeBuilder(), recipe, 16, 10);
                break;
            }
            case "infuser": {
                recipeMap = RecipeMaps.CHEMICAL_BATH_RECIPES;
                builder = GTCEuRecipes.addStats(recipeMap.recipeBuilder(), recipe, 16, 12);
                break;
            }
            case "melter": {
                recipeMap = RecipeMaps.EXTRACTOR_RECIPES;
                builder = GTCEuRecipes.addStats(recipeMap.recipeBuilder(), recipe, 32, 16);
                break;
            }
            case "supercooler": {
                recipeMap = RecipeMaps.VACUUM_RECIPES;
                builder = GTCEuRecipes.addStats(recipeMap.recipeBuilder(), recipe, 240, 20);
                break;
            }
            case "electrolyser": {
                recipeMap = RecipeMaps.ELECTROLYZER_RECIPES;
                builder = GTCEuRecipes.addStats(recipeMap.recipeBuilder(), recipe, 30, 16);
                break;
            }
            case "ingot_former": {
                recipeMap = RecipeMaps.FLUID_SOLIDFICATION_RECIPES;
                builder = GTCEuRecipes.addStats(recipeMap.recipeBuilder(), recipe, 8, 1);
                break;
            }
            case "pressurizer": {
                if (GTCEuRecipes.isPlateRecipe(recipe)) {
                    recipeMap = RecipeMaps.BENDER_RECIPES;
                    builder = GTCEuRecipes.addStats(recipeMap.recipeBuilder(), recipe, 24, 10);
                    builder.circuitMeta(1);
                    break;
                }
                recipeMap = RecipeMaps.COMPRESSOR_RECIPES;
                builder = GTCEuRecipes.addStats(recipeMap.recipeBuilder(), recipe, 2, 20);
                break;
            }
            case "chemical_reactor": {
                recipeMap = RecipeMaps.CHEMICAL_RECIPES;
                builder = GTCEuRecipes.addStats(recipeMap.recipeBuilder(), recipe, 30, 30);
                break;
            }
            case "salt_mixer": {
                recipeMap = RecipeMaps.MIXER_RECIPES;
                builder = GTCEuRecipes.addStats(recipeMap.recipeBuilder(), recipe, 8, 12);
                break;
            }
            case "crystallizer": {
                recipeMap = RecipeMaps.CHEMICAL_RECIPES;
                builder = GTCEuRecipes.addStats(recipeMap.recipeBuilder(), recipe, 30, 10);
                builder.circuitMeta(0);
                break;
            }
            case "dissolver": {
                recipeMap = RecipeMaps.CHEMICAL_RECIPES;
                builder = GTCEuRecipes.addStats(recipeMap.recipeBuilder(), recipe, 20, 20);
                builder.circuitMeta(1);
                break;
            }
            case "extractor": {
                recipeMap = RecipeMaps.EXTRACTOR_RECIPES;
                builder = GTCEuRecipes.addStats(recipeMap.recipeBuilder(), recipe, 16, 12);
                break;
            }
            case "centrifuge": {
                recipeMap = RecipeMaps.CENTRIFUGE_RECIPES;
                builder = GTCEuRecipes.addStats(recipeMap.recipeBuilder(), recipe, 16, 80);
                builder.circuitMeta(0);
                break;
            }
            case "rock_crusher": {
                recipeMap = RecipeMaps.MACERATOR_RECIPES;
                builder = GTCEuRecipes.addStats(recipeMap.recipeBuilder(), recipe, 20, 12);
            }
        }
        if (recipeMap == null || builder == null) {
            return;
        }
        ArrayList builders = new ArrayList();
        builders.add(builder);
        for (Object input : recipe.itemIngredients()) {
            if (input instanceof OreIngredient) {
                for (RecipeBuilder recipeBuilder : builders) {
                    recipeBuilder.input(((OreIngredient)input).oreName, ((OreIngredient)input).stackSize);
                }
                continue;
            }
            HashSet hashSet = new HashSet();
            ArrayList<RecipeBuilder> arrayList = new ArrayList<RecipeBuilder>();
            for (ItemStack itemStack : input.getInputStackList()) {
                if (itemStack.func_190926_b()) continue;
                Set variantOreList = OreDictHelper.getOreNames((ItemStack)itemStack);
                if (!variantOreList.isEmpty()) {
                    if (hashSet.containsAll(variantOreList)) continue;
                    hashSet.addAll(variantOreList);
                    for (RecipeBuilder recipeBuilder : builders) {
                        arrayList.add(recipeBuilder.copy().input((String)variantOreList.iterator().next(), itemStack.func_190916_E()));
                    }
                    continue;
                }
                for (RecipeBuilder recipeBuilder : builders) {
                    arrayList.add(recipeBuilder.copy().inputs(new ItemStack[]{itemStack}));
                }
            }
            builders = arrayList;
        }
        if (recipeMap == RecipeMaps.FLUID_SOLIDFICATION_RECIPES) {
            MetaItem.MetaValueItem mold = GTCEuRecipes.getIngotFormerMold(recipe);
            for (RecipeBuilder recipeBuilder : builders) {
                recipeBuilder.notConsumable(mold);
            }
        }
        for (Object input : recipe.fluidIngredients()) {
            if (input.getInputStackList().isEmpty()) continue;
            for (RecipeBuilder recipeBuilder : builders) {
                recipeBuilder.fluidInputs(new FluidStack[]{(FluidStack)input.getInputStackList().get(0)});
            }
        }
        for (IItemIngredient output : recipe.itemProducts()) {
            if (output instanceof ChanceItemIngredient) {
                ChanceItemIngredient chanceItemIngredient = (ChanceItemIngredient)output;
                List list = output.getOutputStackList();
                if (list.isEmpty()) continue;
                for (RecipeBuilder recipeBuilder : builders) {
                    recipeBuilder.chancedOutput((ItemStack)list.get(0), (int)(chanceItemIngredient.meanStackSize * 10000.0), 0);
                }
                continue;
            }
            List list = output.getOutputStackList();
            if (list.isEmpty()) continue;
            for (RecipeBuilder recipeBuilder : builders) {
                recipeBuilder.outputs(new ItemStack[]{(ItemStack)list.get(0)});
            }
        }
        for (IItemIngredient output : recipe.fluidProducts()) {
            if (output instanceof ChanceFluidIngredient) {
                ChanceFluidIngredient chanceFluidIngredient = (ChanceFluidIngredient)output;
                List list = output.getOutputStackList();
                for (RecipeBuilder recipeBuilder : builders) {
                    recipeBuilder.chancedFluidOutput((FluidStack)list.get(0), (int)(chanceFluidIngredient.meanStackSize * 10000.0), 0);
                }
                continue;
            }
            List list = output.getOutputStackList();
            if (list.isEmpty()) continue;
            for (RecipeBuilder recipeBuilder : builders) {
                recipeBuilder.fluidOutputs(new FluidStack[]{(FluidStack)list.get(0)});
            }
        }
        boolean built = false;
        for (RecipeBuilder recipeBuilder : builders) {
            if (recipeBuilder.getInputs().isEmpty() && recipeBuilder.getFluidInputs().isEmpty()) continue;
            recipeBuilder.buildAndRegister();
            built = true;
        }
        if (built && NCConfig.gtce_recipe_logging) {
            NCUtil.getLogger().info("Injected GTCEu " + recipeMap.unlocalizedName + " recipe: " + RecipeHelper.getRecipeString((IRecipe)recipe));
            NomiLabs.LOGGER.info("This recipe was overrided by Nomi Labs' NC Fixes.");
        }
    }

    private static RecipeBuilder<?> addStats(RecipeBuilder<?> builder, ProcessorRecipe recipe, int processPower, int processTime) {
        return builder.EUt(Math.max((int)recipe.getBaseProcessPower((double)processPower), 1)).duration((int)recipe.getBaseProcessTime(20.0 * (double)processTime));
    }

    private static boolean isPlateRecipe(ProcessorRecipe recipe) {
        ItemStack output = (ItemStack)((IItemIngredient)recipe.itemProducts().get(0)).getStack();
        return output != null && OreDictHelper.hasOrePrefix((ItemStack)output, (String[])new String[]{"plate", "plateDense"});
    }

    private static MetaItem.MetaValueItem getIngotFormerMold(ProcessorRecipe recipe) {
        ItemStack output = (ItemStack)((IItemIngredient)recipe.itemProducts().get(0)).getStack();
        if (output != null) {
            if (OreDictHelper.hasOrePrefix((ItemStack)output, (String[])new String[]{"ingot"})) {
                return MetaItems.SHAPE_MOLD_INGOT;
            }
            if (OreDictHelper.hasOrePrefix((ItemStack)output, (String[])new String[]{"block"})) {
                return MetaItems.SHAPE_MOLD_BLOCK;
            }
        }
        return MetaItems.SHAPE_MOLD_BALL;
    }
}

