/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.integration.top;

import com.nomiceu.nomilabs.integration.top.LabsFluidStackElement;
import com.nomiceu.nomilabs.integration.top.LabsTOPManager;
import com.nomiceu.nomilabs.integration.top.RecipeOutputsProvider;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class LabsChancedFluidStackElement
extends LabsFluidStackElement {
    private final int chance;

    public LabsChancedFluidStackElement(@NotNull FluidStack stack, int chance) {
        super(stack);
        this.chance = chance;
    }

    public LabsChancedFluidStackElement(@NotNull ByteBuf buf) {
        super(buf);
        this.chance = buf.readInt();
    }

    @Override
    public void render(int x, int y) {
        super.render(x, y);
        RecipeOutputsProvider.renderChance(this.chance, x, y);
    }

    @Override
    public void toBytes(@NotNull ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.chance);
    }

    @Override
    public int getID() {
        return LabsTOPManager.CHANCED_FLUID_STACK_ELEMENT;
    }
}

