/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.integration.top;

import com.nomiceu.nomilabs.NomiLabs;
import com.nomiceu.nomilabs.integration.top.LabsTOPManager;
import com.nomiceu.nomilabs.util.LabsTranslate;
import io.netty.buffer.ByteBuf;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.client.ElementTextRender;
import mcjty.theoneprobe.network.NetworkTools;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class LabsFluidNameElement
implements IElement {
    private final String fluidName;
    private final int amount;
    private final boolean showLang;
    private final String translatedName;

    public LabsFluidNameElement(FluidStack fluid, boolean showLang) {
        this.fluidName = fluid.getFluid().getName();
        this.amount = fluid.amount;
        this.showLang = showLang;
        this.translatedName = fluid.getUnlocalizedName();
    }

    public LabsFluidNameElement(ByteBuf byteBuf) {
        this.fluidName = NetworkTools.readStringUTF8((ByteBuf)byteBuf);
        this.amount = byteBuf.readInt();
        this.showLang = byteBuf.readBoolean();
        this.translatedName = LabsFluidNameElement.translateFluid(this.fluidName, this.amount, "LabsFluidNameElement");
    }

    public int getWidth() {
        return ElementTextRender.getWidth((String)this.getTranslated());
    }

    public int getHeight() {
        return 10;
    }

    public void toBytes(ByteBuf byteBuf) {
        NetworkTools.writeStringUTF8((ByteBuf)byteBuf, (String)this.fluidName);
        byteBuf.writeInt(this.amount);
        byteBuf.writeBoolean(this.showLang);
    }

    public void render(int x, int y) {
        ElementTextRender.render((String)(TextStyleClass.NAME + this.getTranslated()), (int)x, (int)y);
    }

    public int getID() {
        return LabsTOPManager.FLUID_NAME_ELEMENT;
    }

    public String getTranslated() {
        if (this.showLang) {
            return LabsTranslate.translate("nomilabs.gui.top_override.fluid", this.translatedName);
        }
        return this.translatedName;
    }

    public static String translateFluid(@Nullable String fluidName, int amount, String packet) {
        if (fluidName == null || fluidName.isEmpty()) {
            return "";
        }
        Fluid fluid = FluidRegistry.getFluid((String)fluidName);
        if (fluid == null) {
            NomiLabs.LOGGER.error("Received Fluid Info Packet {} with Unknown Fluid {}!", (Object)packet, (Object)fluidName);
            return LabsTranslate.translate(fluidName, new Object[0]);
        }
        return fluid.getLocalizedName(new FluidStack(fluid, amount));
    }
}

