/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.integration.top;

import com.nomiceu.nomilabs.NomiLabs;
import com.nomiceu.nomilabs.integration.top.LabsTOPManager;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.utils.RenderUtil;
import io.netty.buffer.ByteBuf;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.network.NetworkTools;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LabsFluidStackElement
implements IElement {
    private final String fluidName;
    private final int color;
    private final int amount;
    @Nullable
    private TextureAtlasSprite sprite = null;

    public LabsFluidStackElement(@NotNull FluidStack stack) {
        this.fluidName = FluidRegistry.getFluidName((Fluid)stack.getFluid());
        this.color = stack.getFluid().getColor(stack);
        this.amount = stack.amount;
    }

    public LabsFluidStackElement(@NotNull ByteBuf buf) {
        this.fluidName = NetworkTools.readStringUTF8((ByteBuf)buf);
        this.color = buf.readInt();
        this.amount = buf.readInt();
    }

    public void render(int x, int y) {
        if (this.sprite == null) {
            this.sprite = LabsFluidStackElement.getFluidAtlasSprite("LabsFluidStackElement", this.fluidName);
        }
        GlStateManager.func_179147_l();
        if (this.sprite != null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            RenderUtil.setGlColorFromInt((int)this.color, (int)255);
            RenderUtil.drawFluidTexture((double)(x + 1), (double)(y - 1), (TextureAtlasSprite)this.sprite, (int)2, (int)2, (double)0.0);
        }
        if (this.amount > 0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
            Minecraft minecraft = Minecraft.func_71410_x();
            String format = TextFormattingUtil.formatLongToCompactString((long)this.amount) + "L";
            minecraft.field_71466_p.func_175063_a(format, (float)((x + 17) * 2 - 1 - minecraft.field_71466_p.func_78256_a(format)), (float)((y + 17) * 2 - 1 - minecraft.field_71466_p.field_78288_b), 0xFFFFFF);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179084_k();
    }

    public int getWidth() {
        return 16;
    }

    public int getHeight() {
        return 16;
    }

    public void toBytes(@NotNull ByteBuf buf) {
        NetworkTools.writeStringUTF8((ByteBuf)buf, (String)this.fluidName);
        buf.writeInt(this.color);
        buf.writeInt(this.amount);
    }

    public int getID() {
        return LabsTOPManager.FLUID_STACK_ELEMENT;
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public static TextureAtlasSprite getFluidAtlasSprite(String packet, String fluidName) {
        Fluid fluid = FluidRegistry.getFluid((String)fluidName);
        if (fluid == null) {
            NomiLabs.LOGGER.error("Received Fluid Info Packet {} with Unknown Fluid {}!", (Object)packet, (Object)fluidName);
            return null;
        }
        String actualLocation = fluid.getStill().toString();
        if (actualLocation.contains("material_sets/fluid/") && (actualLocation.contains("/gas") || actualLocation.contains("/plasma"))) {
            actualLocation = actualLocation.replace("material_sets/fluid/", "material_sets/dull/");
        }
        return Minecraft.func_71410_x().func_147117_R().func_110572_b(actualLocation);
    }
}

