/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.integration.top;

import com.nomiceu.nomilabs.config.LabsConfig;
import mcjty.lib.api.power.IBigPower;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.elements.ElementProgress;
import mcjty.theoneprobe.compat.RedstoneFluxTools;
import mcjty.theoneprobe.config.Config;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Loader;

public class LabsRFInfoProvider
implements IProbeInfoProvider {
    public String getID() {
        return "nomilabs:rf_provider";
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo info, EntityPlayer player, World world, IBlockState state, IProbeHitData data) {
        IEnergyStorage handler;
        if (LabsConfig.topSettings.rfProviderMode == 0) {
            return;
        }
        TileEntity te = world.func_175625_s(data.getPos());
        if (te == null) {
            return;
        }
        if (te instanceof IBigPower) {
            long energy = ((IBigPower)te).getStoredPower();
            long maxEnergy = ((IBigPower)te).getCapacity();
            this.addRFInfo(info, LabsConfig.topSettings.rfProviderMode, energy, maxEnergy);
            return;
        }
        if (Loader.isModLoaded((String)"redstoneflux") && RedstoneFluxTools.isEnergyHandler((TileEntity)te)) {
            int energy = RedstoneFluxTools.getEnergy((TileEntity)te);
            int maxEnergy = RedstoneFluxTools.getMaxEnergy((TileEntity)te);
            this.addRFInfo(info, LabsConfig.topSettings.rfProviderMode, energy, maxEnergy);
            return;
        }
        if (te.hasCapability(CapabilityEnergy.ENERGY, null) && (handler = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
            this.addRFInfo(info, LabsConfig.topSettings.rfProviderMode, handler.getEnergyStored(), handler.getMaxEnergyStored());
        }
    }

    private void addRFInfo(IProbeInfo probeInfo, int rfMode, long energy, long maxEnergy) {
        if (rfMode == 1) {
            probeInfo.progress(energy, maxEnergy, probeInfo.defaultProgressStyle().suffix("RF").filledColor(Config.rfbarFilledColor).alternateFilledColor(Config.rfbarAlternateFilledColor).borderColor(Config.rfbarBorderColor).numberFormat(Config.rfFormat));
        } else {
            probeInfo.text(TextStyleClass.PROGRESS + "RF: " + ElementProgress.format((long)energy, (NumberFormat)Config.rfFormat, (String)"RF"));
        }
    }
}

