/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.integration.top;

import com.nomiceu.nomilabs.config.LabsConfig;
import com.nomiceu.nomilabs.gregtech.mixinhelper.AccessibleAbstractRecipeLogic;
import com.nomiceu.nomilabs.integration.top.LabsChancedFluidNameElement;
import com.nomiceu.nomilabs.integration.top.LabsChancedFluidStackElement;
import com.nomiceu.nomilabs.integration.top.LabsChancedItemStackElement;
import com.nomiceu.nomilabs.integration.top.LabsFluidNameElement;
import com.nomiceu.nomilabs.integration.top.LabsFluidStackElement;
import com.nomiceu.nomilabs.util.ItemMeta;
import com.nomiceu.nomilabs.util.LabsTranslate;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IWorkable;
import gregtech.integration.theoneprobe.provider.CapabilityInfoProvider;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IItemStyle;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.elements.ElementItemStack;
import mcjty.theoneprobe.apiimpl.styles.ItemStyle;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import mcjty.theoneprobe.config.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class RecipeOutputsProvider
extends CapabilityInfoProvider<IWorkable> {
    private static final int AMT_IN_ROW = 10;
    private static final DecimalFormat format = new DecimalFormat("#.#");

    public String getID() {
        return "nomilabs:recipe_outputs";
    }

    @NotNull
    protected Capability<IWorkable> getCapability() {
        return GregtechTileCapabilities.CAPABILITY_WORKABLE;
    }

    protected void addProbeInfo(IWorkable capability, IProbeInfo info, EntityPlayer player, TileEntity tile, IProbeHitData data) {
        IProbeInfo panel;
        if (!LabsConfig.topSettings.enableGTRecipeOutput) {
            return;
        }
        if (capability.getProgress() <= 0 || !(capability instanceof AccessibleAbstractRecipeLogic)) {
            return;
        }
        AccessibleAbstractRecipeLogic recipe = (AccessibleAbstractRecipeLogic)capability;
        if (!recipe.labs$isValidForOutputTop()) {
            return;
        }
        Pair<List<Pair<String, ElementItemStack>>, List<Pair<LabsFluidNameElement, LabsFluidStackElement>>> itemFluidLists = this.createItemFluidElementLists(recipe);
        List items = (List)itemFluidLists.getLeft();
        List fluids = (List)itemFluidLists.getRight();
        if (items.isEmpty() && fluids.isEmpty()) {
            return;
        }
        boolean showDetailed = items.size() + fluids.size() <= Config.showItemDetailThresshold && player.func_70093_af();
        IProbeInfo mainPanel = info.vertical().text(LabsTranslate.topTranslate("nomilabs.top.recipe_outputs")).vertical(info.defaultLayoutStyle().borderColor(Integer.valueOf(Config.chestContentsBorderColor)).spacing(5));
        if (showDetailed) {
            for (Pair entry : items) {
                mainPanel.horizontal(new LayoutStyle().spacing(10).alignment(ElementAlignment.ALIGN_CENTER)).element((IElement)entry.getValue()).text(TextStyleClass.INFO + (String)entry.getKey());
            }
            for (Pair entry : fluids) {
                mainPanel.horizontal(new LayoutStyle().spacing(10).alignment(ElementAlignment.ALIGN_CENTER)).element((IElement)entry.getValue()).element((IElement)entry.getKey());
            }
            return;
        }
        boolean condense = items.size() == 1 && fluids.size() == 1;
        IProbeInfo sharedHorizontal = null;
        if (condense) {
            sharedHorizontal = this.createHorizontalLayout(mainPanel);
        }
        if (!items.isEmpty()) {
            panel = condense ? sharedHorizontal : this.createHorizontalLayout(mainPanel);
            this.addOutputs(items, panel, Pair::getValue);
        }
        if (!fluids.isEmpty()) {
            panel = condense ? sharedHorizontal : this.createHorizontalLayout(mainPanel);
            this.addOutputs(fluids, panel, Pair::getValue);
        }
    }

    public static String formatChance(int chance) {
        return format.format((double)chance / 100.0) + "%";
    }

    private <T> void addOutputs(List<T> list, IProbeInfo panel, Function<T, IElement> getElement) {
        int idx = 0;
        for (T entry : list) {
            if (idx >= 10) break;
            panel.element(getElement.apply(entry));
            ++idx;
        }
    }

    private IProbeInfo createHorizontalLayout(IProbeInfo mainPanel) {
        return mainPanel.horizontal((ILayoutStyle)new LayoutStyle().spacing(4));
    }

    private Pair<List<Pair<String, ElementItemStack>>, List<Pair<LabsFluidNameElement, LabsFluidStackElement>>> createItemFluidElementLists(AccessibleAbstractRecipeLogic recipe) {
        Map<ItemMeta, Integer> outputs = this.getUnique(recipe.labs$getOutputs().subList(0, recipe.labs$getNonChancedItemAmt()), ItemStack::func_190926_b, ItemMeta::new, ItemStack::func_190916_E);
        Map<Pair, Integer> chancedOutputs = this.getUnique(recipe.labs$getChancedItemOutputs(), chanced -> ((ItemStack)chanced.getKey()).func_190926_b() || (Integer)chanced.getValue() == 0, chanced -> Pair.of((Object)new ItemMeta((ItemStack)chanced.getKey()), (Object)((Integer)chanced.getValue())), chanced -> ((ItemStack)chanced.getKey()).func_190916_E());
        IItemStyle style = new ItemStyle().width(16).height(16);
        ArrayList<Pair> items = new ArrayList<Pair>();
        for (Map.Entry<ItemMeta, Integer> entry : outputs.entrySet()) {
            ItemStack stack3 = entry.getKey().toStack(entry.getValue());
            items.add(Pair.of((Object)stack3.func_82833_r(), (Object)new ElementItemStack(stack3, style)));
        }
        for (Map.Entry<ItemMeta, Integer> entry : chancedOutputs.entrySet()) {
            ItemStack stack2 = ((ItemMeta)((Pair)entry.getKey()).getKey()).toStack(entry.getValue());
            String display = stack2.func_82833_r() + " (" + RecipeOutputsProvider.formatChance((Integer)((Pair)entry.getKey()).getValue()) + ")";
            items.add(Pair.of((Object)display, (Object)((Object)new LabsChancedItemStackElement(stack2, (Integer)((Pair)entry.getKey()).getValue(), style))));
        }
        Map<Fluid, Integer> fluidOutputs = this.getUnique(recipe.labs$getFluidOutputs().subList(0, recipe.labs$getNonChancedFluidAmt()), stack -> stack.amount == 0, FluidStack::getFluid, stack -> stack.amount);
        Map<Pair, Integer> map = this.getUnique(recipe.labs$getChancedFluidOutputs(), chanced -> ((FluidStack)chanced.getKey()).amount == 0 || (Integer)chanced.getValue() == 0, chanced -> Pair.of((Object)((FluidStack)chanced.getKey()).getFluid(), (Object)((Integer)chanced.getValue())), chanced -> ((FluidStack)chanced.getKey()).amount);
        ArrayList<Pair> fluids = new ArrayList<Pair>();
        for (Map.Entry<Fluid, Integer> entry : fluidOutputs.entrySet()) {
            FluidStack stack2 = new FluidStack(entry.getKey(), entry.getValue().intValue());
            fluids.add(Pair.of((Object)new LabsFluidNameElement(stack2, false), (Object)new LabsFluidStackElement(stack2)));
        }
        for (Map.Entry<Fluid, Integer> entry : map.entrySet()) {
            FluidStack stack3 = new FluidStack((Fluid)((Pair)entry.getKey()).getKey(), entry.getValue().intValue());
            fluids.add(Pair.of((Object)new LabsChancedFluidNameElement(stack3, (Integer)((Pair)entry.getKey()).getValue(), false), (Object)new LabsChancedFluidStackElement(stack3, (Integer)((Pair)entry.getKey()).getValue())));
        }
        return Pair.of(items, fluids);
    }

    private <T, K> Map<K, Integer> getUnique(List<T> stacks, Function<T, Boolean> emptyCheck, Function<T, K> getKey, Function<T, Integer> getCount) {
        Object2ObjectLinkedOpenHashMap map = new Object2ObjectLinkedOpenHashMap();
        for (Object stack : stacks) {
            if (emptyCheck.apply(stack).booleanValue()) continue;
            map.compute(getKey.apply(stack), (key, count) -> {
                if (count == null) {
                    count = 0;
                }
                return count + (Integer)getCount.apply(stack);
            });
        }
        return map;
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderChance(int chance, int x, int y) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179084_k();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
        Minecraft mc = Minecraft.func_71410_x();
        String chanceTxt = RecipeOutputsProvider.formatChance(chance);
        mc.field_71466_p.func_175063_a(chanceTxt, (float)((x + 17) * 2 - 1 - mc.field_71466_p.func_78256_a(chanceTxt)), (float)(y * 2), -1);
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        GlStateManager.func_179147_l();
    }
}

