/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.item;

import com.nomiceu.nomilabs.util.LabsTranslate;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBase
extends Item {
    private final IRarity rarity;
    @Nullable
    private final LabsTranslate.Translatable[] description;

    public ItemBase(ResourceLocation rl, CreativeTabs tab) {
        this(rl, tab, (IRarity)EnumRarity.COMMON, 64);
    }

    public ItemBase(ResourceLocation rl, CreativeTabs tab, @NotNull IRarity rarity) {
        this(rl, tab, rarity, 64);
    }

    public ItemBase(ResourceLocation rl, CreativeTabs tab, @NotNull IRarity rarity, int stackSize) {
        this(rl, tab, rarity, stackSize, new LabsTranslate.Translatable[]{null});
    }

    public ItemBase(ResourceLocation rl, CreativeTabs tab, @NotNull IRarity rarity, int stackSize, LabsTranslate.Translatable ... description) {
        this.setRegistryName(rl);
        this.func_77637_a(tab);
        this.func_77625_d(stackSize);
        this.rarity = rarity;
        this.description = description;
    }

    @NotNull
    public IRarity getForgeRarity(@NotNull ItemStack stack) {
        return this.rarity;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, @NotNull ITooltipFlag flagIn) {
        if (this.description == null) {
            return;
        }
        Arrays.stream(this.description).filter(Objects::nonNull).map(LabsTranslate.Translatable::translate).forEach(tooltip::add);
    }
}

