/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.item;

import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.nomiceu.nomilabs.util.LabsTranslate;
import crazypants.enderio.api.capacitor.CapabilityCapacitorData;
import crazypants.enderio.api.capacitor.ICapacitorData;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.base.lang.Lang;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemCapacitor
extends Item {
    public final LabsCapacitorData data;

    public ItemCapacitor(ResourceLocation rl, CreativeTabs tab, LabsCapacitorData data) {
        this.func_77637_a(tab);
        this.setRegistryName(rl);
        this.func_77625_d(64);
        this.data = data;
    }

    @Optional.Method(modid="enderio")
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<String> tooltip, @NotNull ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(LabsTranslate.translate("tooltip.nomilabs.capacitors.description", new Object[0]));
        if (SpecialTooltipHandler.showAdvancedTooltips()) {
            SpecialTooltipHandler.addDetailedTooltipFromResources(tooltip, (String)Lang.MACHINE_UPGRADE.getKey());
        } else {
            SpecialTooltipHandler.addShowDetailsTooltip(tooltip);
        }
    }

    @Optional.Method(modid="enderio")
    @Nullable
    public ICapabilityProvider initCapabilities(@NotNull ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new CapacitorCapabilityProvider(this.data);
    }

    public static enum LabsCapacitorData implements ICapacitorData
    {
        COMPRESSED("compressed_octadic", 4.0f),
        DOUBLE_COMPRESSED("double_compressed_octadic", 5.0f);

        private final String name;
        private final float level;

        private LabsCapacitorData(String name, float level) {
            this.name = name;
            this.level = level;
        }

        public float getUnscaledValue(@NotNull ICapacitorKey iCapacitorKey) {
            return this.level;
        }

        @NotNull
        public String getUnlocalizedName() {
            return this.name;
        }

        @NotNull
        public String getLocalizedName() {
            return LabsTranslate.translate("nomilabs." + this.name, new Object[0]);
        }
    }

    public static class CapacitorCapabilityProvider
    implements ICapabilityProvider {
        private final ICapacitorData data;

        public CapacitorCapabilityProvider(ICapacitorData data) {
            this.data = data;
        }

        public boolean hasCapability(@NotNull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityCapacitorData.getCapNN();
        }

        @Nullable
        public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityCapacitorData.getCapNN()) {
                return (T)CapabilityCapacitorData.getCapNN().cast((Object)this.data);
            }
            return null;
        }
    }
}

