/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.item;

import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IFrameable;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockController;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockSlave;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityTrim;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.MaterialData;
import com.nomiceu.nomilabs.NomiLabs;
import com.nomiceu.nomilabs.integration.jei.LabsJEIPlugin;
import com.nomiceu.nomilabs.item.registry.LabsItems;
import com.nomiceu.nomilabs.util.LabsTranslate;
import eutros.framedcompactdrawers.block.tile.TileControllerCustom;
import eutros.framedcompactdrawers.block.tile.TileSlaveCustom;
import eutros.framedcompactdrawers.registry.ModBlocks;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@Optional.Interface(iface="com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IFrameable", modid="storagedrawers")
public class ItemHandFramingTool
extends Item
implements IFrameable {
    public static final String MAT_SIDE_TAG = "MatS";
    public static final String MAT_TRIM_TAG = "MatT";
    public static final String MAT_FRONT_TAG = "MatF";

    public ItemHandFramingTool(ResourceLocation rl, CreativeTabs tab) {
        this.func_77625_d(1);
        this.func_77637_a(tab);
        this.setRegistryName(rl);
        this.addDescription();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<String> tooltip, @NotNull ITooltipFlag flagIn) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null || this.getItemStackFromKey(tagCompound, MAT_SIDE_TAG).func_190926_b()) {
            tooltip.add(LabsTranslate.translate("tooltip.nomilabs.hand_framing_tool.not_set", new Object[0]));
            return;
        }
        this.addTooltipItem(tooltip, "tooltip.nomilabs.hand_framing_tool.side", this.getItemStackFromKey(tagCompound, MAT_SIDE_TAG));
        this.addTooltipItem(tooltip, "tooltip.nomilabs.hand_framing_tool.trim", this.getItemStackFromKey(tagCompound, MAT_TRIM_TAG));
        this.addTooltipItem(tooltip, "tooltip.nomilabs.hand_framing_tool.front", this.getItemStackFromKey(tagCompound, MAT_FRONT_TAG));
    }

    @SideOnly(value=Side.CLIENT)
    private void addTooltipItem(@NotNull List<String> tooltip, String translationKey, ItemStack stack) {
        tooltip.add(LabsTranslate.translate(translationKey, stack.func_190926_b() ? "-" : stack.func_82833_r()));
    }

    @Optional.Method(modid="storagedrawers")
    @NotNull
    public EnumActionResult func_180614_a(@NotNull EntityPlayer player, World world, @NotNull BlockPos pos, @NotNull EnumHand hand, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        NBTTagCompound tagCompound;
        EnumActionResult actionResult = EnumActionResult.PASS;
        if (world.func_175623_d(pos)) {
            return actionResult;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!(block instanceof INetworked)) {
            return actionResult;
        }
        actionResult = EnumActionResult.FAIL;
        ItemStack tool = player.func_184586_b(hand);
        if (!this.isDecorating(Objects.requireNonNull(block.getRegistryName()))) {
            EnumActionResult framedResult = this.makeFramedState(world, pos);
            if (framedResult != null) {
                return framedResult;
            }
            actionResult = EnumActionResult.SUCCESS;
        }
        if ((tagCompound = tool.func_77978_p()) == null) {
            return actionResult;
        }
        ItemStack matS = this.getItemStackFromKey(tagCompound, MAT_SIDE_TAG);
        if (matS.func_190926_b()) {
            return actionResult;
        }
        ItemStack matT = this.getItemStackFromKey(tagCompound, MAT_TRIM_TAG);
        ItemStack matF = this.getItemStackFromKey(tagCompound, MAT_FRONT_TAG);
        MaterialData materialData = this.getMaterialData(world, pos);
        if (materialData != null) {
            materialData.setSide(matS.func_77946_l());
            materialData.setTrim(matT.func_77946_l());
            materialData.setFront(matF.func_77946_l());
        }
        world.func_175704_b(pos, pos);
        return EnumActionResult.SUCCESS;
    }

    private boolean isDecorating(ResourceLocation registryName) {
        return registryName.func_110624_b().equals("framedcompactdrawers") || registryName.equals((Object)new ResourceLocation("storagedrawers", "customdrawers")) || registryName.equals((Object)new ResourceLocation("storagedrawers", "customtrim"));
    }

    @Optional.Method(modid="storagedrawers")
    @Nullable
    private EnumActionResult makeFramedState(World world, BlockPos pos) {
        if (Loader.isModLoaded((String)"framedcompactdrawers") && this.makeFramedCompactState(world, pos)) {
            return null;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof BlockCompDrawers || block instanceof BlockController || block instanceof BlockSlave) {
            return EnumActionResult.FAIL;
        }
        if (block instanceof BlockDrawers) {
            this.handleDrawerFraming(world, pos, com.jaquadro.minecraft.storagedrawers.core.ModBlocks.customDrawers.func_176203_a(block.func_176201_c(state)));
            return null;
        }
        IBlockState newState = com.jaquadro.minecraft.storagedrawers.core.ModBlocks.customTrim.func_176223_P();
        world.func_175656_a(pos, newState);
        return null;
    }

    @Optional.Method(modid="framedcompactdrawers")
    private boolean makeFramedCompactState(World world, BlockPos pos) {
        IBlockState newState;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof BlockCompDrawers) {
            this.handleDrawerFraming(world, pos, ModBlocks.framedCompactDrawer.func_176223_P());
            return true;
        }
        if (block instanceof BlockController) {
            newState = ModBlocks.framedDrawerController.func_176203_a(block.func_176201_c(state) - 2);
        } else if (block instanceof BlockSlave) {
            newState = ModBlocks.framedSlave.func_176223_P();
        } else {
            return false;
        }
        world.func_175656_a(pos, newState);
        return true;
    }

    @Optional.Method(modid="storagedrawers")
    private void handleDrawerFraming(World world, BlockPos pos, IBlockState state) {
        NBTTagCompound tag = new NBTTagCompound();
        TileEntityDrawers tile = Objects.requireNonNull((TileEntityDrawers)world.func_175625_s(pos));
        tile.writeToPortableNBT(tag);
        int direction = tile.getDirection();
        world.func_175656_a(pos, state);
        tile = Objects.requireNonNull((TileEntityDrawers)world.func_175625_s(pos));
        tile.readFromPortableNBT(tag);
        tile.setDirection(direction);
    }

    @Nullable
    @Optional.Method(modid="storagedrawers")
    private MaterialData getMaterialData(World world, BlockPos pos) {
        MaterialData data;
        TileEntity tile = world.func_175625_s(pos);
        if (Loader.isModLoaded((String)"framedcompactdrawers") && (data = this.getMaterialDataFramed(tile)) != null) {
            return data;
        }
        if (tile instanceof TileEntityDrawers) {
            TileEntityDrawers drawers = (TileEntityDrawers)tile;
            return drawers.material();
        }
        if (tile instanceof TileEntityTrim) {
            TileEntityTrim trim = (TileEntityTrim)tile;
            return trim.material();
        }
        NomiLabs.LOGGER.fatal("[Hand Framing Tool] Failed to get the material data of tile entity at block pos {}.", (Object)pos);
        return null;
    }

    @Nullable
    @Optional.Method(modid="framedcompactdrawers")
    private MaterialData getMaterialDataFramed(TileEntity tile) {
        if (tile instanceof TileControllerCustom) {
            TileControllerCustom controller = (TileControllerCustom)tile;
            return controller.material();
        }
        if (tile instanceof TileSlaveCustom) {
            TileSlaveCustom slave = (TileSlaveCustom)tile;
            return slave.material();
        }
        return null;
    }

    private ItemStack getItemStackFromKey(NBTTagCompound tagCompound, String key) {
        if (!tagCompound.func_74764_b(key)) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(tagCompound.func_74775_l(key));
    }

    @Optional.Method(modid="storagedrawers")
    public ItemStack decorate(ItemStack itemStack, ItemStack matSide, ItemStack matTrim, ItemStack matFront) {
        ItemStack stack = new ItemStack((Item)LabsItems.HAND_FRAMING_TOOL, 1);
        NBTTagCompound compound = new NBTTagCompound();
        if (!matSide.func_190926_b()) {
            compound.func_74782_a(MAT_SIDE_TAG, (NBTBase)ItemHandFramingTool.getMaterialTag(matSide));
        }
        if (!matTrim.func_190926_b()) {
            compound.func_74782_a(MAT_TRIM_TAG, (NBTBase)ItemHandFramingTool.getMaterialTag(matTrim));
        }
        if (!matFront.func_190926_b()) {
            compound.func_74782_a(MAT_FRONT_TAG, (NBTBase)ItemHandFramingTool.getMaterialTag(matFront));
        }
        stack.func_77982_d(compound);
        return stack;
    }

    private static NBTTagCompound getMaterialTag(@Nonnull ItemStack stack) {
        NBTTagCompound tag = new NBTTagCompound();
        stack.func_77955_b(tag);
        return tag;
    }

    public void addDescription() {
        LabsJEIPlugin.addDescription(new ItemStack((Item)this), LabsTranslate.translatable("item.nomilabs.hand_framing_tool.desc1", new Object[0]), LabsTranslate.translatable("item.nomilabs.hand_framing_tool.desc2", new Object[0]), LabsTranslate.translatable("item.nomilabs.hand_framing_tool.desc3", new Object[0]), LabsTranslate.translatable("item.nomilabs.hand_framing_tool.desc4", new Object[0]), LabsTranslate.translatable("item.nomilabs.hand_framing_tool.desc5", new Object[0]), LabsTranslate.translatable("item.nomilabs.hand_framing_tool.desc6", new Object[0]));
    }
}

