/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin;

import com.google.common.collect.ImmutableMap;
import com.nomiceu.nomilabs.NomiLabs;
import com.nomiceu.nomilabs.config.LabsConfig;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.tuple.Pair;
import zone.rong.mixinbooter.ILateMixinLoader;

public class LabsLateMixinLoader
implements ILateMixinLoader {
    public static final Map<String, Boolean> modMixinsConfig = new ImmutableMap.Builder().put((Object)"draconicevolution", (Object)LabsConfig.modIntegration.draconicEvolutionIntegration.enableDraconicEvolutionIntegration).put((Object)"nuclearcraft", (Object)LabsConfig.modIntegration.enableNuclearCraftIntegration).put((Object)"extrautils2", (Object)LabsConfig.modIntegration.enableExtraUtils2Integration).put((Object)"gregtech", (Object)true).put((Object)"jei", (Object)true).put((Object)"advancedrocketry", (Object)true).put((Object)"architecturecraft", (Object)LabsConfig.modIntegration.enableArchitectureCraftIntegration).put((Object)"effortlessbuilding", (Object)LabsConfig.modIntegration.effortlessBuildingIntegration.enableEffortlessBuildingIntegration).put((Object)"groovyscript", (Object)true).put((Object)"controlling", (Object)true).put((Object)"defaultworldgenerator-port", (Object)LabsConfig.modIntegration.enableDefaultWorldGenIntegration).put((Object)"deepmoblearning", (Object)true).put((Object)"ftbutilities", (Object)LabsConfig.modIntegration.enableFTBUtilsIntegration).put((Object)"topaddons", (Object)LabsConfig.modIntegration.enableTopAddonsIntegration).put((Object)"theoneprobe", (Object)true).put((Object)"appliedenergistics2", (Object)true).put((Object)"nae2", (Object)true).put((Object)"enderio", (Object)true).put((Object)"actuallyadditions", (Object)true).put((Object)"thermalfoundation", (Object)true).put((Object)"betterquesting", (Object)true).put((Object)"betterp2p", (Object)true).put((Object)"storagedrawers", (Object)true).put((Object)"solarflux", (Object)LabsConfig.modIntegration.solarFluxPerformanceOptions.enableSolarFluxPerformance).put((Object)"armorplus", (Object)true).put((Object)"gcym", (Object)true).build();
    public static final Map<Pair<String, String>, Boolean> specialMixinsConfig = ImmutableMap.of((Object)Pair.of((Object)"advancedrocketry", (Object)"prerework"), (Object)LabsConfig.modIntegration.enableAdvancedRocketryIntegration);

    public List<String> getMixinConfigs() {
        List<String> mixins = modMixinsConfig.keySet().stream().map(mod -> "mixins.nomilabs." + mod + ".json").collect(Collectors.toList());
        mixins.addAll(specialMixinsConfig.keySet().stream().map(pair -> "mixins.nomilabs." + (String)pair.getKey() + "." + (String)pair.getValue() + ".json").collect(Collectors.toList()));
        return mixins;
    }

    public boolean shouldMixinConfigQueue(String mixinConfig) {
        String[] parts = mixinConfig.split("\\.");
        if (parts.length != 4 && parts.length != 5) {
            NomiLabs.LOGGER.fatal("Mixin Config Check Failed! Invalid Length.");
            NomiLabs.LOGGER.fatal("Mixin Config: {}", (Object)mixinConfig);
            return true;
        }
        if (!Objects.equals(parts[1], "nomilabs")) {
            NomiLabs.LOGGER.error("Non Nomi-Labs Mixin Found in Mixin Queue. This is probably an error. Skipping...");
            NomiLabs.LOGGER.error("Mixin Config: {}", (Object)mixinConfig);
            return true;
        }
        if (!Loader.isModLoaded((String)parts[2])) {
            NomiLabs.LOGGER.error("Mod '{}' is not loaded. If this is a normal Nomi-CEu instance, this is probably an error.", (Object)parts[2]);
            NomiLabs.LOGGER.error("Not Loading Mixin Config {}", (Object)mixinConfig);
            return false;
        }
        if (parts.length == 5) {
            Pair cfgPair = Pair.of((Object)parts[2], (Object)parts[3]);
            if (!specialMixinsConfig.containsKey(cfgPair) || !specialMixinsConfig.get(cfgPair).booleanValue()) {
                NomiLabs.LOGGER.info("Integration for Mod '{}', Special Type {}, is not enabled, or does not exist.", (Object)parts[2], (Object)parts[3]);
                NomiLabs.LOGGER.info("Not Loading Mixin Config {}", (Object)mixinConfig);
                return false;
            }
            return true;
        }
        if (!modMixinsConfig.containsKey(parts[2]) || !modMixinsConfig.get(parts[2]).booleanValue()) {
            NomiLabs.LOGGER.info("Integration for Mod '{}' is not enabled, or does not exist.", (Object)parts[2]);
            NomiLabs.LOGGER.info("Not Loading Mixin Config {}", (Object)mixinConfig);
            return false;
        }
        return true;
    }
}

