/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.ae2;

import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.data.IAEFluidStack;
import appeng.fluids.helper.DualityFluidInterface;
import appeng.fluids.helper.IFluidInterfaceHost;
import appeng.fluids.util.AEFluidInventory;
import appeng.fluids.util.AEFluidStack;
import appeng.fluids.util.IAEFluidInventory;
import appeng.fluids.util.IAEFluidTank;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import com.nomiceu.nomilabs.integration.ae2.LabsImplNetworkFluidInventory;
import com.nomiceu.nomilabs.integration.ae2.NotifiableFluidInventory;
import net.minecraftforge.fluids.FluidStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DualityFluidInterface.class}, remap=false)
public abstract class DualityFluidInterfaceMixin
implements NotifiableFluidInventory {
    @Shadow
    @Final
    @Mutable
    private AEFluidInventory tanks;
    @Shadow
    @Final
    private IFluidInterfaceHost iHost;
    @Shadow
    @Final
    private AENetworkProxy gridProxy;
    @Shadow
    @Final
    private IActionSource mySource;
    @Shadow
    @Final
    public static int NUMBER_OF_TANKS;
    @Shadow
    @Final
    public static int TANK_CAPACITY;

    @Shadow
    public abstract void saveChanges();

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void injectNetworkInv(AENetworkProxy networkProxy, IFluidInterfaceHost ih, CallbackInfo ci) {
        this.tanks = new LabsImplNetworkFluidInventory(this::labs$getStorageGrid, this.mySource, (IAEFluidInventory)this, NUMBER_OF_TANKS, TANK_CAPACITY);
    }

    @Override
    @Unique
    public void labs$onFluidInventoryChanged(IAEFluidTank inventory, FluidStack added, FluidStack removed) {
        if (inventory == this.tanks) {
            if (added != null) {
                this.iHost.onStackReturnNetwork((IAEFluidStack)AEFluidStack.fromFluidStack((FluidStack)added));
            }
            this.saveChanges();
        }
    }

    @Unique
    private IStorageGrid labs$getStorageGrid() {
        try {
            return this.gridProxy.getStorage();
        }
        catch (GridAccessException e) {
            return null;
        }
    }
}

