/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.ae2;

import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.data.IAEItemStack;
import appeng.helpers.DualityInterface;
import appeng.helpers.IInterfaceHost;
import appeng.helpers.UnlockCraftingEvent;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.inv.IAEAppEngInventory;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.nomiceu.nomilabs.integration.ae2.LabsImplNetworkInventory;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RangedWrapper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DualityInterface.class}, remap=false)
public class DualityInterfaceMixin {
    @Shadow
    @Final
    @Mutable
    private AppEngInternalInventory storage;
    @Shadow
    @Final
    private AENetworkProxy gridProxy;
    @Shadow
    @Final
    private IActionSource mySource;
    @Shadow
    @Final
    public static int NUMBER_OF_STORAGE_SLOTS;
    @Shadow
    @Nullable
    private UnlockCraftingEvent unlockEvent;
    @Shadow
    @Nullable
    private IAEItemStack unlockStack;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void injectNetworkInv(AENetworkProxy networkProxy, IInterfaceHost ih, CallbackInfo ci) {
        this.storage = new LabsImplNetworkInventory(this::labs$getStorageGrid, this.mySource, (IAEAppEngInventory)this, NUMBER_OF_STORAGE_SLOTS, 512);
    }

    @WrapOperation(method={"getAdaptor"}, at={@At(value="NEW", target="(Lnet/minecraftforge/items/IItemHandlerModifiable;II)Lnet/minecraftforge/items/wrapper/RangedWrapper;")}, require=1)
    private RangedWrapper returnNewRangedWrapper(IItemHandlerModifiable compose, int minSlot, int maxSlotExclusive, Operation<RangedWrapper> original) {
        return ((LabsImplNetworkInventory)compose).getBufferWrapper(minSlot);
    }

    @Redirect(method={"onPushPatternSuccess"}, at=@At(value="INVOKE", target="Lappeng/api/networking/crafting/ICraftingPatternDetails;getPrimaryOutput()Lappeng/api/storage/data/IAEItemStack;"), require=1)
    private IAEItemStack copyStack(ICraftingPatternDetails instance) {
        return instance.getPrimaryOutput().copy();
    }

    @Inject(method={"onStackReturnedToNetwork"}, at={@At(value="HEAD")}, cancellable=true)
    private void properlyCheckMetaAndNBT(IAEItemStack stack, CallbackInfo ci) {
        if (this.unlockEvent != UnlockCraftingEvent.RESULT || this.unlockStack == null) {
            return;
        }
        ci.cancel();
        if (this.unlockStack.isSameType(stack)) {
            long remainingAmount = this.unlockStack.getStackSize() - stack.getStackSize();
            if (remainingAmount <= 0L) {
                this.unlockEvent = null;
                this.unlockStack = null;
            } else {
                this.unlockStack.setStackSize(remainingAmount);
            }
        }
    }

    @Redirect(method={"getTermName"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/Item;getItemStackDisplayName(Lnet/minecraft/item/ItemStack;)Ljava/lang/String;", remap=true), require=1, remap=false)
    private String useUnlocalized(Item instance, ItemStack stack) {
        return instance.func_77667_c(stack);
    }

    @Unique
    private IStorageGrid labs$getStorageGrid() {
        try {
            return this.gridProxy.getStorage();
        }
        catch (GridAccessException e) {
            return null;
        }
    }
}

