/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.ae2;

import appeng.api.AEApi;
import appeng.api.config.StorageFilter;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.fluids.util.AEFluidStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"appeng.fluids.parts.FluidHandlerAdapter$InventoryCache"}, remap=false)
public class FluidHandlerAdapterInventoryCacheMixin {
    @Shadow
    @Final
    private IFluidHandler fluidHandler;
    @Shadow
    IItemList<IAEFluidStack> currentlyCached;
    @Shadow
    @Final
    private StorageFilter mode;

    @Inject(method={"update"}, at={@At(value="HEAD")}, cancellable=true)
    private void useTankContents(CallbackInfoReturnable<List<IAEFluidStack>> cir) {
        ArrayList<IAEFluidStack> changes = new ArrayList<IAEFluidStack>();
        IFluidTankProperties[] tankProperties = this.fluidHandler.getTankProperties();
        IItemList currentlyOnStorage = ((IFluidStorageChannel)AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class)).createList();
        for (IFluidTankProperties tankProperty : tankProperties) {
            FluidStack contents = tankProperty.getContents();
            if (this.mode == StorageFilter.EXTRACTABLE_ONLY && this.fluidHandler.drain(contents, false) == null) continue;
            currentlyOnStorage.add((IAEStack)AEFluidStack.fromFluidStack((FluidStack)contents));
        }
        for (IAEFluidStack is : this.currentlyCached) {
            is.setStackSize(-is.getStackSize());
        }
        for (IAEFluidStack is : currentlyOnStorage) {
            this.currentlyCached.add((IAEStack)is);
        }
        for (IAEFluidStack is : this.currentlyCached) {
            if (is.getStackSize() == 0L) continue;
            changes.add(is);
        }
        this.currentlyCached = currentlyOnStorage;
        cir.setReturnValue(changes);
    }
}

