/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.ae2;

import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.storage.NetworkInventoryHandler;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={NetworkInventoryHandler.class}, remap=false)
public abstract class NetworkInventoryHandlerMixin<T extends IAEStack<T>> {
    @Shadow
    @Final
    private static Comparator<Integer> PRIORITY_SORTER;
    @Shadow
    @Final
    private NavigableMap<Integer, List<IMEInventoryHandler<T>>> priorityInventory;
    @Shadow
    @Final
    private NavigableMap<Integer, List<IMEInventoryHandler<T>>> stickyPriorityInventory;
    @Unique
    private final NavigableMap<Integer, List<IMEInventoryHandler<T>>> labs$craftingPriorityInventory = new TreeMap<Integer, List<IMEInventoryHandler<T>>>(PRIORITY_SORTER);

    @Shadow
    protected abstract boolean diveList(NetworkInventoryHandler<T> var1, Actionable var2);

    @Shadow
    protected abstract boolean testPermission(IActionSource var1, SecurityPermissions var2);

    @Shadow
    protected abstract void surface(NetworkInventoryHandler<T> var1, Actionable var2);

    @Shadow
    protected abstract IItemList<T> iterateInventories(IItemList<T> var1, NavigableMap<Integer, List<IMEInventoryHandler<T>>> var2);

    @Inject(method={"addNewStorage"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleCrafting(IMEInventoryHandler<T> h, CallbackInfo ci) {
        int priority = h.getPriority();
        NavigableMap<Integer, List<IMEInventoryHandler<T>>> map = h instanceof ICraftingGrid ? this.labs$craftingPriorityInventory : (h.isSticky() ? this.stickyPriorityInventory : this.priorityInventory);
        map.computeIfAbsent(priority, _priority -> new ArrayList()).add(h);
        ci.cancel();
    }

    @Inject(method={"injectItems"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkCraftingInv(T input, Actionable type, IActionSource src, CallbackInfoReturnable<T> cir) {
        IMEInventoryHandler inv;
        Iterator ii;
        if (this.diveList(this.labs$this(), type)) {
            cir.setReturnValue(input);
            return;
        }
        if (this.testPermission(src, SecurityPermissions.INJECT)) {
            this.surface(this.labs$this(), type);
            cir.setReturnValue(input);
            return;
        }
        for (List invList : this.labs$craftingPriorityInventory.values()) {
            Iterator ii2 = invList.iterator();
            while (ii2.hasNext() && input != null) {
                IMEInventoryHandler inv2 = (IMEInventoryHandler)ii2.next();
                if (!inv2.canAccept(input) || !inv2.isPrioritized(input) && inv2.extractItems(input, Actionable.SIMULATE, src) == null) continue;
                input = inv2.injectItems(input, type, src);
            }
        }
        if (input == null) {
            this.surface(this.labs$this(), type);
            cir.setReturnValue(null);
            return;
        }
        boolean stickyInventoryFound = false;
        for (List stickyInvList : this.stickyPriorityInventory.values()) {
            ii = stickyInvList.iterator();
            while (ii.hasNext() && input != null) {
                inv = (IMEInventoryHandler)ii.next();
                if (!inv.validForPass(1) || !inv.canAccept(input) || !inv.isPrioritized(input) && inv.extractItems(input, Actionable.SIMULATE, src) == null) continue;
                input = inv.injectItems(input, type, src);
                stickyInventoryFound = true;
            }
        }
        if (stickyInventoryFound) {
            this.surface(this.labs$this(), type);
            cir.setReturnValue(input);
            return;
        }
        for (List invList : this.priorityInventory.values()) {
            ii = invList.iterator();
            while (ii.hasNext() && input != null) {
                inv = (IMEInventoryHandler)ii.next();
                if (!inv.validForPass(1) || !inv.canAccept(input) || !inv.isPrioritized(input) && inv.extractItems(input, Actionable.SIMULATE, src) == null) continue;
                input = inv.injectItems(input, type, src);
            }
            ii = invList.iterator();
            while (ii.hasNext() && input != null) {
                inv = (IMEInventoryHandler)ii.next();
                if (!inv.validForPass(2) || !inv.canAccept(input) || inv.isPrioritized(input)) continue;
                input = inv.injectItems(input, type, src);
            }
        }
        this.surface(this.labs$this(), type);
        cir.setReturnValue(input);
    }

    @Inject(method={"getAvailableItems"}, at={@At(value="INVOKE", target="Lappeng/me/storage/NetworkInventoryHandler;surface(Lappeng/me/storage/NetworkInventoryHandler;Lappeng/api/config/Actionable;)V")}, require=1, remap=false)
    private void iterateCrafting(IItemList<T> out, CallbackInfoReturnable<IItemList<T>> cir) {
        this.iterateInventories(out, this.labs$craftingPriorityInventory);
    }

    @Unique
    private NetworkInventoryHandler<T> labs$this() {
        return (NetworkInventoryHandler)this;
    }
}

