/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.architecturecraft;

import com.elytradev.architecture.common.block.BlockArchitecture;
import com.elytradev.architecture.common.block.BlockShape;
import com.elytradev.architecture.common.tile.TileShape;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockShape.class}, remap=false)
public class BlockShapeMixin
extends BlockArchitecture<TileShape> {
    public BlockShapeMixin(Material material) {
        super(material);
    }

    @Inject(method={"acBlockStrength"}, at={@At(value="INVOKE", target="Lcom/elytradev/architecture/common/block/BlockShape;acCanHarvestBlock(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/player/EntityPlayer;)Z")}, cancellable=true)
    private static void baseBlockStrength(IBlockState state, EntityPlayer player, World world, BlockPos pos, CallbackInfoReturnable<Float> cir, @Local(ordinal=1) float strength) {
        cir.setReturnValue((Object)Float.valueOf(state.func_177230_c().canHarvestBlock((IBlockAccess)world, pos, player) ? strength / 100.0f : strength / 30.0f));
    }

    public boolean canHarvestBlock(@NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EntityPlayer player) {
        TileShape te = TileShape.get((IBlockAccess)world, (BlockPos)pos);
        if (te == null) {
            return super.canHarvestBlock(world, pos, player);
        }
        IBlockState baseState = te.getBaseBlockState();
        Block baseBlock = baseState.func_177230_c();
        if (baseState.func_185904_a().func_76229_l()) {
            return true;
        }
        ItemStack stack = player.func_184614_ca();
        String tool = baseBlock.getHarvestTool(baseState);
        if (stack.func_190926_b() || tool == null) {
            return player.func_184823_b(baseState);
        }
        int toolLevel = stack.func_77973_b().getHarvestLevel(stack, tool, player, baseState);
        if (toolLevel < 0) {
            return player.func_184823_b(baseState);
        }
        return toolLevel >= baseBlock.getHarvestLevel(baseState);
    }
}

