/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.architecturecraft;

import com.elytradev.architecture.client.render.shape.RenderRoof;
import com.elytradev.architecture.client.render.shape.RenderShape;
import com.elytradev.architecture.client.render.target.RenderTargetBase;
import com.elytradev.architecture.client.render.texture.ITexture;
import com.elytradev.architecture.common.helpers.Trans3;
import com.elytradev.architecture.common.tile.TileShape;
import com.nomiceu.nomilabs.integration.architecturecraft.LabsShapes;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RenderRoof.class}, remap=false)
public abstract class RenderRoofMixin
extends RenderShape {
    @Unique
    private Map<Integer, Runnable> ID_TO_RENDER_MAP = null;

    @Shadow
    protected abstract void bottomQuad();

    @Shadow
    protected abstract void backQuad();

    @Shadow
    protected abstract void beginNegZSlope();

    @Shadow
    protected abstract void beginQuad();

    @Shadow
    protected abstract void vertex(double var1, double var3, double var5, double var7, double var9);

    @Shadow
    protected abstract void endFace();

    @Shadow
    protected abstract void beginPosXFace();

    @Shadow
    protected abstract void beginTriangle();

    @Shadow
    protected abstract void beginNegZFace();

    @Shadow
    protected abstract void beginPosZFace();

    @Shadow
    protected abstract void beginNegXFace();

    public RenderRoofMixin(TileShape te, ITexture[] textures, Trans3 t, RenderTargetBase target) {
        super(te, textures, t, target);
    }

    @Unique
    private Map<Integer, Runnable> getRenderMap() {
        if (this.ID_TO_RENDER_MAP != null) {
            return this.ID_TO_RENDER_MAP;
        }
        this.ID_TO_RENDER_MAP = new HashMap<Integer, Runnable>();
        this.ID_TO_RENDER_MAP.put(LabsShapes.SLOPE_TILE_A1.id, this::renderSlopeA1);
        this.ID_TO_RENDER_MAP.put(LabsShapes.SLOPE_TILE_A2.id, this::renderSlopeA2);
        this.ID_TO_RENDER_MAP.put(LabsShapes.SLOPE_TILE_B1.id, this::renderSlopeB1);
        this.ID_TO_RENDER_MAP.put(LabsShapes.SLOPE_TILE_B2.id, this::renderSlopeB2);
        this.ID_TO_RENDER_MAP.put(LabsShapes.SLOPE_TILE_B3.id, this::renderSlopeB3);
        this.ID_TO_RENDER_MAP.put(LabsShapes.SLOPE_TILE_C1.id, this::renderSlopeC1);
        this.ID_TO_RENDER_MAP.put(LabsShapes.SLOPE_TILE_C2.id, this::renderSlopeC2);
        this.ID_TO_RENDER_MAP.put(LabsShapes.SLOPE_TILE_C3.id, this::renderSlopeC3);
        this.ID_TO_RENDER_MAP.put(LabsShapes.SLOPE_TILE_C4.id, this::renderSlopeC4);
        return this.ID_TO_RENDER_MAP;
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderCustomSlopes(CallbackInfo ci) {
        int id;
        Map<Integer, Runnable> map = this.getRenderMap();
        if (!map.containsKey(id = this.te.getShape().id)) {
            return;
        }
        map.get(id).run();
        ci.cancel();
    }

    @Unique
    protected void renderSlopeA1() {
        this.renderVariableSlope(1.0, 0.5);
        this.renderVariableFaceLeft(0.0, 0.5);
        this.renderVariableTriangleLeft(0.5, 0.5);
        this.renderVariableFaceRight(0.0, 0.5);
        this.renderVariableTriangleRight(0.5, 0.5);
        this.renderVariableFrontFace(0.5);
        this.bottomQuad();
        this.backQuad();
    }

    @Unique
    protected void renderSlopeA2() {
        this.renderVariableSlope(0.5, 0.0);
        this.renderVariableTriangleLeft(0.0, 0.5);
        this.renderVariableTriangleRight(0.0, 0.5);
        this.bottomQuad();
        this.renderVariableBackFace(0.5);
    }

    @Unique
    protected void renderSlopeB1() {
        this.renderVariableSlope(1.0, 0.66666);
        this.renderVariableFaceLeft(0.0, 0.66666);
        this.renderVariableTriangleLeft(0.66666, 0.33333);
        this.renderVariableFaceRight(0.0, 0.66666);
        this.renderVariableTriangleRight(0.66666, 0.33333);
        this.renderVariableFrontFace(0.66666);
        this.bottomQuad();
        this.backQuad();
    }

    @Unique
    protected void renderSlopeB2() {
        this.renderVariableSlope(0.66666, 0.33333);
        this.renderVariableFaceLeft(0.0, 0.33333);
        this.renderVariableTriangleLeft(0.33333, 0.33333);
        this.renderVariableFaceRight(0.0, 0.33333);
        this.renderVariableTriangleRight(0.33333, 0.33333);
        this.renderVariableFrontFace(0.33333);
        this.bottomQuad();
        this.renderVariableBackFace(0.66666);
    }

    @Unique
    protected void renderSlopeB3() {
        this.renderVariableSlope(0.33333, 0.0);
        this.renderVariableTriangleLeft(0.0, 0.33333);
        this.renderVariableTriangleRight(0.0, 0.33333);
        this.bottomQuad();
        this.renderVariableBackFace(0.33333);
    }

    @Unique
    protected void renderSlopeC1() {
        this.renderVariableSlope(1.0, 0.75);
        this.renderVariableFaceLeft(0.0, 0.75);
        this.renderVariableTriangleLeft(0.75, 0.25);
        this.renderVariableFaceRight(0.0, 0.75);
        this.renderVariableTriangleRight(0.75, 0.25);
        this.renderVariableFrontFace(0.75);
        this.bottomQuad();
        this.backQuad();
    }

    @Unique
    protected void renderSlopeC2() {
        this.renderVariableSlope(0.75, 0.5);
        this.renderVariableFaceLeft(0.0, 0.5);
        this.renderVariableTriangleLeft(0.5, 0.25);
        this.renderVariableFaceRight(0.0, 0.5);
        this.renderVariableTriangleRight(0.5, 0.25);
        this.renderVariableFrontFace(0.5);
        this.bottomQuad();
        this.renderVariableBackFace(0.75);
    }

    @Unique
    protected void renderSlopeC3() {
        this.renderVariableSlope(0.5, 0.25);
        this.renderVariableFaceLeft(0.0, 0.25);
        this.renderVariableTriangleLeft(0.25, 0.25);
        this.renderVariableFaceRight(0.0, 0.25);
        this.renderVariableTriangleRight(0.25, 0.25);
        this.renderVariableFrontFace(0.25);
        this.bottomQuad();
        this.renderVariableBackFace(0.5);
    }

    @Unique
    protected void renderSlopeC4() {
        this.renderVariableSlope(0.25, 0.0);
        this.renderVariableTriangleLeft(0.0, 0.25);
        this.renderVariableTriangleRight(0.0, 0.25);
        this.bottomQuad();
        this.renderVariableBackFace(0.25);
    }

    @Unique
    protected void renderVariableSlope(double start, double end) {
        this.beginNegZSlope();
        this.beginQuad();
        this.vertex(1.0, start, 1.0, 0.0, 0.0);
        this.vertex(1.0, end, 0.0, 0.0, 1.0);
        this.vertex(0.0, end, 0.0, 1.0, 1.0);
        this.vertex(0.0, start, 1.0, 1.0, 0.0);
        this.endFace();
    }

    @Unique
    protected void renderVariableTriangleLeft(double offset, double height) {
        this.beginPosXFace();
        this.beginTriangle();
        this.vertex(1.0, offset + height, 1.0, 0.0, 0.0);
        this.vertex(1.0, offset, 1.0, 0.0, 1.0 - height);
        this.vertex(1.0, offset, 0.0, 1.0, 1.0 - height);
        this.endFace();
    }

    @Unique
    protected void renderVariableTriangleRight(double offset, double height) {
        this.beginNegXFace();
        this.beginTriangle();
        this.vertex(0.0, offset + height, 1.0, 1.0, 0.0);
        this.vertex(0.0, offset, 0.0, 0.0, 1.0 - height);
        this.vertex(0.0, offset, 1.0, 1.0, 1.0 - height);
        this.endFace();
    }

    @Unique
    protected void renderVariableFaceLeft(double offset, double height) {
        this.beginNegXFace();
        this.beginQuad();
        this.vertex(0.0, offset + height, 0.0, 0.0, 1.0 - height);
        this.vertex(0.0, offset, 0.0, 0.0, 1.0);
        this.vertex(0.0, offset, 1.0, 1.0, 1.0);
        this.vertex(0.0, offset + height, 1.0, 1.0, 1.0 - height);
        this.endFace();
    }

    @Unique
    protected void renderVariableFaceRight(double offset, double height) {
        this.beginPosXFace();
        this.beginQuad();
        this.vertex(1.0, offset + height, 1.0, 0.0, 1.0 - height);
        this.vertex(1.0, offset, 1.0, 0.0, 1.0);
        this.vertex(1.0, offset, 0.0, 1.0, 1.0);
        this.vertex(1.0, offset + height, 0.0, 1.0, 1.0 - height);
        this.endFace();
    }

    @Unique
    protected void renderVariableFrontFace(double height) {
        this.beginNegZFace();
        this.beginQuad();
        this.vertex(1.0, height, 0.0, 0.0, 1.0 - height);
        this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
        this.vertex(0.0, height, 0.0, 1.0, 1.0 - height);
        this.endFace();
    }

    @Unique
    protected void renderVariableBackFace(double height) {
        this.beginPosZFace();
        this.beginQuad();
        this.vertex(0.0, height, 1.0, 0.0, 1.0 - height);
        this.vertex(0.0, 0.0, 1.0, 0.0, 1.0);
        this.vertex(1.0, 0.0, 1.0, 1.0, 1.0);
        this.vertex(1.0, height, 1.0, 1.0, 1.0 - height);
        this.endFace();
    }
}

