/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.betterp2p;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.nomiceu.nomilabs.NomiLabs;
import com.projecturanus.betterp2p.item.BetterMemoryCardModes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BetterMemoryCardModes.class}, remap=false)
public class BetterMemoryCardModesMixin {
    @Unique
    private static BiMap<Integer, BetterMemoryCardModes> LABS_ORDER_CACHE;

    @Inject(method={"next"}, at={@At(value="HEAD")}, cancellable=true)
    private void changeNextOrder(boolean reverse, CallbackInfoReturnable<BetterMemoryCardModes> cir) {
        Integer current;
        if (LABS_ORDER_CACHE == null) {
            BetterMemoryCardModes[] modes;
            LABS_ORDER_CACHE = HashBiMap.create();
            for (BetterMemoryCardModes mode : modes = BetterMemoryCardModes.values()) {
                if (mode == BetterMemoryCardModes.UNBIND || mode == BetterMemoryCardModes.COPY) continue;
                LABS_ORDER_CACHE.put((Object)LABS_ORDER_CACHE.size(), (Object)mode);
            }
            LABS_ORDER_CACHE.put((Object)LABS_ORDER_CACHE.size(), (Object)BetterMemoryCardModes.UNBIND);
            NomiLabs.LOGGER.debug("[BetterMemoryCardModes] Created Labs Order Cache: {}", LABS_ORDER_CACHE);
        }
        if ((current = (Integer)LABS_ORDER_CACHE.inverse().get((Object)this)) == null) {
            NomiLabs.LOGGER.error("[BetterMemoryCardModes] Current Index returned null for Mode {}!", (Object)this);
            NomiLabs.LOGGER.error("[BetterMemoryCardModes] This may simply be a legacy card, if mode was COPY.");
            return;
        }
        int toGet = (reverse ? current - 1 : current + 1) % LABS_ORDER_CACHE.size();
        BetterMemoryCardModes result = (BetterMemoryCardModes)LABS_ORDER_CACHE.get((Object)toGet);
        if (result != null) {
            cir.setReturnValue((Object)result);
        } else {
            NomiLabs.LOGGER.error("[BetterMemoryCardModes] Next Modifier returned null for Index {}!", (Object)toGet);
        }
    }
}

