/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.betterp2p;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.security.ISecurityGrid;
import appeng.helpers.IInterfaceHost;
import appeng.me.GridAccessException;
import appeng.me.cache.helpers.TunnelCollection;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.util.Platform;
import com.nomiceu.nomilabs.integration.betterp2p.AccessibleGridServerCache;
import com.projecturanus.betterp2p.network.data.GridServerCache;
import com.projecturanus.betterp2p.network.data.P2PLocation;
import com.projecturanus.betterp2p.util.p2p.TunnelInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GridServerCache.class}, remap=false)
public abstract class GridServerCacheMixin
implements AccessibleGridServerCache {
    @Shadow
    @Final
    private IGrid grid;
    @Shadow
    @Final
    private EntityPlayer player;
    @Shadow
    @Final
    private Map<P2PLocation, PartP2PTunnel<?>> listP2P;

    @Shadow
    protected abstract PartP2PTunnel<?> updateP2P(P2PLocation var1, PartP2PTunnel<?> var2, short var3, boolean var4, String var5);

    @Shadow
    protected abstract void handleInterface(IInterfaceHost var1, IInterfaceHost var2, IInterfaceHost var3, IInterfaceHost var4, List<ItemStack> var5);

    @Shadow
    protected abstract PartP2PTunnel<?> changeP2PType(PartP2PTunnel<?> var1, TunnelInfo var2);

    @Inject(method={"changeP2PType"}, at={@At(value="RETURN")}, cancellable=true)
    private void restoreName(PartP2PTunnel<?> tunnel, TunnelInfo newType, CallbackInfoReturnable<PartP2PTunnel<?>> cir) {
        PartP2PTunnel result = (PartP2PTunnel)cir.getReturnValue();
        if (result == null) {
            return;
        }
        if (tunnel.hasCustomInventoryName()) {
            result.setCustomName(tunnel.getCustomInventoryName());
        }
        cir.setReturnValue((Object)result);
    }

    @Inject(method={"changeAllP2Ps"}, at={@At(value="HEAD")}, cancellable=true)
    private void properlyChangeAllP2PTypes(P2PLocation p2p, TunnelInfo newType, CallbackInfoReturnable<Boolean> cir) {
        PartP2PTunnel<?> tunnel = this.listP2P.get(p2p);
        if (tunnel == null) {
            cir.setReturnValue((Object)false);
            return;
        }
        if (tunnel.getFrequency() == 0) {
            PartP2PTunnel<?> result = this.changeP2PType(tunnel, newType);
            cir.setReturnValue((Object)(result != null ? 1 : 0));
            return;
        }
        try {
            TunnelCollection inputs = tunnel.getProxy().getP2P().getInputs(tunnel.getFrequency(), tunnel.getClass());
            TunnelCollection outputs = tunnel.getProxy().getP2P().getOutputs(tunnel.getFrequency(), tunnel.getClass());
            ArrayList toModify = new ArrayList();
            inputs.forEach(toModify::add);
            outputs.forEach(toModify::add);
            if (toModify.isEmpty()) {
                toModify.add(tunnel);
            }
            for (PartP2PTunnel partP2PTunnel : toModify) {
                PartP2PTunnel<?> result = this.changeP2PType(partP2PTunnel, newType);
                if (result != null) continue;
                cir.setReturnValue((Object)false);
                return;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        cir.setReturnValue((Object)true);
    }

    @Inject(method={"linkP2P"}, at={@At(value="INVOKE", target="Lappeng/parts/p2p/PartP2PTunnel;getFrequency()S")}, require=1, cancellable=true)
    private void properlyLinkP2P(P2PLocation inputIndex, P2PLocation outputIndex, CallbackInfoReturnable<Pair<PartP2PTunnel<?>, PartP2PTunnel<?>>> cir) {
        PartP2PTunnel<?> input = this.listP2P.get(inputIndex);
        PartP2PTunnel<?> output = this.listP2P.get(outputIndex);
        short frequency = input.getFrequency();
        try {
            if (frequency == 0 || input.isOutput()) {
                frequency = input.getProxy().getP2P().newFrequency();
            }
        }
        catch (GridAccessException e) {
            cir.setReturnValue(null);
            return;
        }
        PartP2PTunnel<?> inputResult = this.updateP2P(inputIndex, input, frequency, false, input.hasCustomInventoryName() ? input.getCustomInventoryName() : "");
        PartP2PTunnel<?> outputResult = this.updateP2P(outputIndex, output, frequency, true, output.hasCustomInventoryName() ? output.getCustomInventoryName() : "");
        if (input instanceof IInterfaceHost) {
            IInterfaceHost inputHost = (IInterfaceHost)input;
            if (output instanceof IInterfaceHost) {
                IInterfaceHost outputHost = (IInterfaceHost)output;
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                this.handleInterface(inputHost, outputHost, (IInterfaceHost)inputResult, (IInterfaceHost)outputResult, drops);
                Platform.spawnDrops((World)this.player.field_70170_p, (BlockPos)output.getLocation().getPos(), drops);
            }
        }
        cir.setReturnValue((Object)new Pair(inputResult, outputResult));
    }

    @Override
    @Unique
    public PartP2PTunnel<?> labs$changeIsInput(P2PLocation key, boolean isInput) {
        ISecurityGrid securityGrid;
        IGrid iGrid = this.grid;
        if (iGrid instanceof ISecurityGrid && !(securityGrid = (ISecurityGrid)iGrid).hasPermission(this.player, SecurityPermissions.BUILD)) {
            return null;
        }
        PartP2PTunnel<?> p2p = this.listP2P.get(key);
        if (p2p == null) {
            return null;
        }
        if (p2p.isOutput() == !isInput) {
            this.player.func_145747_a((ITextComponent)new TextComponentTranslation("nomilabs.gui.better_p2p.error.same_output", new Object[]{isInput ? "Input" : "Output"}));
            return null;
        }
        return this.updateP2P(key, p2p, p2p.getFrequency(), !isInput, p2p.hasCustomInventoryName() ? p2p.getCustomInventoryName() : "");
    }

    @Override
    @Unique
    public boolean labs$addInput(P2PLocation key, short sourceFrequency) {
        return this.labs$addAs(key, sourceFrequency, true);
    }

    @Override
    @Unique
    public boolean labs$addOutput(P2PLocation key, short sourceFrequency) {
        return this.labs$addAs(key, sourceFrequency, false);
    }

    @Unique
    private boolean labs$addAs(P2PLocation key, short sourceFrequency, boolean isInput) {
        ISecurityGrid securityGrid;
        IGrid iGrid = this.grid;
        if (iGrid instanceof ISecurityGrid && !(securityGrid = (ISecurityGrid)iGrid).hasPermission(this.player, SecurityPermissions.BUILD)) {
            return false;
        }
        PartP2PTunnel<?> p2p = this.listP2P.get(key);
        if (p2p == null) {
            return false;
        }
        return this.updateP2P(key, p2p, sourceFrequency, !isInput, p2p.hasCustomInventoryName() ? p2p.getCustomInventoryName() : "") != null;
    }
}

