/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.betterp2p;

import com.google.common.collect.ImmutableList;
import com.nomiceu.nomilabs.integration.betterp2p.AccessibleGuiAdvancedMemoryCard;
import com.nomiceu.nomilabs.integration.betterp2p.AccessibleInfoList;
import com.nomiceu.nomilabs.integration.betterp2p.LabsClientCache;
import com.nomiceu.nomilabs.integration.betterp2p.SortDirectionWidgetButton;
import com.nomiceu.nomilabs.integration.betterp2p.SortModeWidgetButton;
import com.nomiceu.nomilabs.integration.betterp2p.SortModes;
import com.nomiceu.nomilabs.util.LabsTranslate;
import com.projecturanus.betterp2p.client.gui.GuiAdvancedMemoryCard;
import com.projecturanus.betterp2p.client.gui.InfoList;
import com.projecturanus.betterp2p.client.gui.InfoWrapper;
import com.projecturanus.betterp2p.client.gui.widget.GuiScale;
import com.projecturanus.betterp2p.client.gui.widget.WidgetButton;
import com.projecturanus.betterp2p.client.gui.widget.WidgetScrollBar;
import com.projecturanus.betterp2p.client.gui.widget.WidgetTypeSelector;
import com.projecturanus.betterp2p.item.BetterMemoryCardModes;
import com.projecturanus.betterp2p.network.data.P2PLocation;
import com.projecturanus.betterp2p.network.packet.S2COpenGui;
import java.util.List;
import kotlin.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Keyboard;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GuiAdvancedMemoryCard.class}, remap=false)
public abstract class GuiAdvancedMemoryCardMixin
extends GuiScreen
implements AccessibleGuiAdvancedMemoryCard {
    @Shadow
    private BetterMemoryCardModes mode;
    @Shadow
    @Final
    private WidgetTypeSelector typeSelector;
    @Shadow
    @Final
    private InfoList infos;
    @Shadow
    @Final
    private WidgetScrollBar scrollBar;
    @Shadow
    private GuiScale scale;
    @Shadow
    @Final
    private WidgetButton refreshButton;
    @Shadow
    private int guiLeft;
    @Shadow
    private int guiTop;
    @Unique
    private SortModeWidgetButton labs$sortModeButton;
    @Unique
    private SortDirectionWidgetButton labs$sortDirectionButton;

    @Shadow
    protected abstract void syncMemoryInfo();

    @Shadow
    protected abstract InfoWrapper getSelectedInfo();

    @Shadow
    protected abstract void refreshOverlay();

    @Override
    @Unique
    public BetterMemoryCardModes labs$getMode() {
        return this.mode;
    }

    @Override
    @Unique
    public void labs$setMode(BetterMemoryCardModes mode) {
        this.mode = mode;
    }

    @Override
    @Unique
    public void labs$syncMemoryInfo() {
        this.syncMemoryInfo();
    }

    @Override
    @Unique
    public void labs$closeTypeSelector() {
        this.typeSelector.setVisible(false);
    }

    @Override
    @Unique
    public void labs$changeSort(boolean forwards) {
        this.labs$getAccessibleInfo().labs$changeSortMode(forwards);
        this.infos.resort();
        this.infos.refilter();
        this.refreshOverlay();
    }

    @Override
    @Unique
    public SortModes labs$getSortMode() {
        return this.labs$getAccessibleInfo().labs$getSortMode();
    }

    @Override
    @Unique
    public void labs$swapSortReversed() {
        this.labs$getAccessibleInfo().labs$setSortReversed(!this.labs$getSortReversed());
        this.infos.resort();
        this.infos.refilter();
        this.refreshOverlay();
    }

    @Override
    @Unique
    public boolean labs$getSortReversed() {
        return this.labs$getAccessibleInfo().labs$getSortReversed();
    }

    @Inject(method={"getSortRules"}, at={@At(value="HEAD")}, cancellable=true)
    private void getCustomSortRules(CallbackInfoReturnable<List<String>> cir) {
        cir.setReturnValue((Object)ImmutableList.of((Object)LabsTranslate.format(LabsTranslate.translate("nomilabs.gui.advanced_memory_card.filter.title", new Object[0]), TextFormatting.BOLD, TextFormatting.UNDERLINE), (Object)("<name>\u00a77 - " + LabsTranslate.translate("nomilabs.gui.advanced_memory_card.filter.name", new Object[0])), (Object)("\u00a79@in\u00a77 - " + LabsTranslate.translate("nomilabs.gui.advanced_memory_card.filter.input", new Object[0])), (Object)("\u00a76@out\u00a77 - " + LabsTranslate.translate("nomilabs.gui.advanced_memory_card.filter.output", new Object[0])), (Object)("\u00a7a@b\u00a77 - " + LabsTranslate.translate("nomilabs.gui.advanced_memory_card.filter.bound", new Object[0])), (Object)("\u00a7c@u\u00a77 - " + LabsTranslate.translate("nomilabs.gui.advanced_memory_card.filter.unbound", new Object[0])), (Object)("\u00a7b@distless=<distance>\u00a77 - " + LabsTranslate.translate("nomilabs.gui.advanced_memory_card.filter.distless", new Object[0])), (Object)("\u00a7d@distmore=<distance>\u00a77 - " + LabsTranslate.translate("nomilabs.gui.advanced_memory_card.filter.distmore", new Object[0])), (Object)("\u00a7e@type=<type1>;<type2>;...\u00a77 - " + LabsTranslate.translate("nomilabs.gui.advanced_memory_card.filter.type", new Object[0])), (Object)"", (Object)LabsTranslate.translateFormat("nomilabs.gui.advanced_memory_card.filter.end", TextFormatting.GRAY, new Object[0])));
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void setup(S2COpenGui msg, CallbackInfo ci) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        this.labs$getAccessibleInfo().labs$setPlayerPos(player.func_174791_d(), player.field_71093_bK);
        this.labs$getAccessibleInfo().labs$setSortMode(LabsClientCache.sortMode);
        this.labs$getAccessibleInfo().labs$setSortReversed(LabsClientCache.sortReversed);
        this.labs$sortModeButton = new SortModeWidgetButton(this.labs$getThis(), 0, 0, 32, 32);
        this.labs$sortDirectionButton = new SortDirectionWidgetButton(this.labs$getThis(), 0, 0, 32, 32);
    }

    @Inject(method={"initGui"}, at={@At(value="HEAD")}, remap=true)
    private void clearExistingButtons(CallbackInfo ci) {
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
    }

    @Inject(method={"initGui"}, at={@At(value="TAIL")}, remap=true)
    private void handleEndInit(CallbackInfo ci) {
        this.labs$properlyResetScrollbar();
        this.refreshButton.setPosition(this.guiLeft - 32, this.guiTop + 162);
        this.labs$sortModeButton.setPosition(this.guiLeft - 32, this.guiTop + 98);
        this.field_146292_n.add(this.labs$sortModeButton);
        this.labs$sortDirectionButton.setPosition(this.guiLeft - 32, this.guiTop + 130);
        this.field_146292_n.add(this.labs$sortDirectionButton);
    }

    @Redirect(method={"initGui"}, at=@At(value="INVOKE", target="Lcom/projecturanus/betterp2p/client/gui/GuiAdvancedMemoryCard;checkInfo()V", remap=false), require=1, remap=true)
    private void cancelExistingChecksInit(GuiAdvancedMemoryCard instance) {
    }

    @Redirect(method={"refreshInfo"}, at=@At(value="INVOKE", target="Lcom/projecturanus/betterp2p/client/gui/GuiAdvancedMemoryCard;checkInfo()V"), require=1)
    private void cancelExistingChecksRefresh(GuiAdvancedMemoryCard instance) {
    }

    @Redirect(method={"updateInfo"}, at=@At(value="INVOKE", target="Lcom/projecturanus/betterp2p/client/gui/GuiAdvancedMemoryCard;checkInfo()V"), require=1)
    private void cancelExistingChecksUpdate(GuiAdvancedMemoryCard instance) {
    }

    @Inject(method={"mouseClicked"}, at={@At(value="INVOKE", target="Lcom/projecturanus/betterp2p/client/gui/InfoList;refilter()V", shift=At.Shift.AFTER, remap=false)}, require=1, remap=true)
    private void properlyResetScrollbarFilterClear(int mouseX, int mouseY, int mouseButton, CallbackInfo ci) {
        this.labs$properlyResetScrollbar();
    }

    @Inject(method={"keyTyped"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    private void allowArrowScroll(char typedChar, int keyCode, CallbackInfo ci) {
        if (keyCode == 200) {
            this.scrollBar.wheel(1);
            ci.cancel();
            return;
        }
        if (keyCode == 208) {
            this.scrollBar.wheel(-1);
            ci.cancel();
        }
    }

    @Inject(method={"keyTyped"}, at={@At(value="INVOKE", target="Lcom/projecturanus/betterp2p/client/gui/InfoList;refilter()V", shift=At.Shift.AFTER, remap=false)}, require=1, remap=true)
    private void properlyResetScrollbarFilterTyped(char typedChar, int keyCode, CallbackInfo ci) {
        this.labs$properlyResetScrollbar();
    }

    @Inject(method={"refreshOverlay"}, at={@At(value="HEAD")})
    private void fillLabsCache(CallbackInfo ci) {
        LabsClientCache.inputLoc.clear();
        LabsClientCache.outputLoc.clear();
        InfoWrapper selected = this.getSelectedInfo();
        if (selected == null) {
            return;
        }
        LabsClientCache.selectedIsOutput = this.getSelectedInfo().getOutput();
        LabsClientCache.lastSelectedRenderChange = System.currentTimeMillis();
        LabsClientCache.renderingSelected = true;
        if (selected.getFrequency() == 0) {
            return;
        }
        this.infos.getSorted().stream().filter(info -> info.getFrequency() == selected.getFrequency()).filter(info -> info.getType() == selected.getType()).filter(info -> info.getLoc().getDim() == selected.getLoc().getDim()).filter(info -> !info.equals((Object)selected)).map(info -> new Pair(info.getOutput() ? LabsClientCache.outputLoc : LabsClientCache.inputLoc, (Object)info.getLoc())).forEach(pair -> ((List)pair.getFirst()).add(new Pair((Object)((P2PLocation)pair.getSecond()).getPos(), (Object)((P2PLocation)pair.getSecond()).getFacing())));
    }

    @Inject(method={"onGuiClosed"}, at={@At(value="HEAD")}, remap=true)
    private void save(CallbackInfo ci) {
        LabsClientCache.sortMode = this.labs$getSortMode();
        LabsClientCache.sortReversed = this.labs$getSortReversed();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Unique
    private void labs$properlyResetScrollbar() {
        this.labs$getAccessibleInfo().labs$properlyResetScrollbar(this.scrollBar, (Integer)this.scale.getSize().invoke((Object)(this.field_146295_m - 75)));
    }

    @Unique
    private AccessibleInfoList labs$getAccessibleInfo() {
        return (AccessibleInfoList)this.infos;
    }

    @Unique
    private GuiAdvancedMemoryCard labs$getThis() {
        return (GuiAdvancedMemoryCard)this;
    }
}

