/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.betterp2p;

import com.google.common.collect.ImmutableList;
import com.nomiceu.nomilabs.integration.betterp2p.AccessibleInfoList;
import com.nomiceu.nomilabs.integration.betterp2p.AccessibleInfoWrapper;
import com.nomiceu.nomilabs.integration.betterp2p.SortModes;
import com.projecturanus.betterp2p.client.gui.Filter;
import com.projecturanus.betterp2p.client.gui.InfoFilter;
import com.projecturanus.betterp2p.client.gui.InfoList;
import com.projecturanus.betterp2p.client.gui.InfoWrapper;
import com.projecturanus.betterp2p.client.gui.widget.WidgetScrollBar;
import com.projecturanus.betterp2p.network.data.P2PLocation;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.math.Vec3d;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={InfoList.class}, remap=false)
public abstract class InfoListMixin
implements AccessibleInfoList {
    @Shadow
    @Final
    private HashMap<P2PLocation, InfoWrapper> masterMap;
    @Shadow
    @Final
    private InfoFilter filter;
    @Unique
    private Vec3d labs$playerPos;
    @Unique
    private int labs$playerDim;
    @Unique
    private SortModes labs$sortMode = SortModes.DEFAULT;
    @Unique
    private boolean labs$sortReversed = false;

    @Shadow
    @Nullable
    public abstract InfoWrapper getSelectedInfo();

    @Shadow
    protected abstract String getSearchStr();

    @Override
    @Unique
    public void labs$setSortMode(SortModes mode) {
        this.labs$sortMode = mode;
    }

    @Override
    @Unique
    public SortModes labs$getSortMode() {
        return this.labs$sortMode;
    }

    @Override
    @Unique
    public void labs$changeSortMode(boolean forwards) {
        int newModeOrdinal = this.labs$sortMode.ordinal() + (forwards ? 1 : -1);
        int maxSize = SortModes.values().length;
        newModeOrdinal = newModeOrdinal < 0 ? maxSize - 1 : (newModeOrdinal %= maxSize);
        this.labs$sortMode = SortModes.values()[newModeOrdinal];
    }

    @Override
    @Unique
    public boolean labs$getSortReversed() {
        return this.labs$sortReversed;
    }

    @Override
    @Unique
    public void labs$setSortReversed(boolean reversed) {
        this.labs$sortReversed = reversed;
    }

    @Override
    @Unique
    public void labs$setPlayerPos(Vec3d pos, int dim) {
        this.labs$playerPos = pos;
        this.labs$playerDim = dim;
        this.labs$calcDistFor(this.masterMap.values());
    }

    @Override
    @Unique
    public void labs$properlyResetScrollbar(WidgetScrollBar scrollBar, int numEntries) {
        int size = Math.max(0, this.labs$getThis().getFiltered().size() - numEntries);
        scrollBar.setRange(0, size, 23);
        scrollBar.setCurrentScroll(0);
    }

    @Unique
    private void labs$calcDistFor(Iterable<InfoWrapper> infos) {
        for (InfoWrapper info : infos) {
            ((AccessibleInfoWrapper)info).labs$calculateDistance(this.labs$playerPos, this.labs$playerDim);
        }
    }

    @Unique
    private void labs$checkInfo() {
        for (InfoWrapper info : this.labs$getThis().getSorted()) {
            if (info.getFrequency() == 0) {
                info.setError(false);
                continue;
            }
            int connections = this.labs$amount(info.getFrequency(), !info.getOutput());
            info.setError(connections == 0);
            ((AccessibleInfoWrapper)info).labs$setConnectionAmt(connections);
        }
    }

    @Unique
    private int labs$amount(int freq, boolean isOutput) {
        int amount = 0;
        for (InfoWrapper info : this.labs$getThis().getSorted()) {
            if (info.getFrequency() != freq || info.getOutput() != isOutput) continue;
            ++amount;
        }
        return amount;
    }

    @Inject(method={"refresh"}, at={@At(value="INVOKE", target="Lcom/projecturanus/betterp2p/client/gui/InfoList;resort()V")}, require=1)
    private void checkInfoBeforeSort1(CallbackInfo ci) {
        this.labs$checkInfo();
    }

    @Inject(method={"rebuild"}, at={@At(value="HEAD")})
    private void calcDistanceInRebuild(Collection<InfoWrapper> updateList, WidgetScrollBar scrollbar, int numEntries, CallbackInfo ci) {
        this.labs$calcDistFor(updateList);
    }

    @Inject(method={"rebuild"}, at={@At(value="INVOKE", target="Lcom/projecturanus/betterp2p/client/gui/InfoList;resort()V")}, require=1)
    private void checkInfoBeforeSort2(Collection<InfoWrapper> updateList, WidgetScrollBar scrollbar, int numEntries, CallbackInfo ci) {
        this.labs$checkInfo();
    }

    @Inject(method={"rebuild"}, at={@At(value="INVOKE", target="Lcom/projecturanus/betterp2p/client/gui/widget/WidgetScrollBar;setRange(III)V")}, require=1, cancellable=true)
    private void replaceOldRebuildScrollbar(Collection<InfoWrapper> updateList, WidgetScrollBar scrollbar, int numEntries, CallbackInfo ci) {
        ci.cancel();
        this.labs$properlyResetScrollbar(scrollbar, numEntries);
    }

    @Inject(method={"update"}, at={@At(value="HEAD")})
    private void calcDistanceInUpdate(Collection<InfoWrapper> updateList, WidgetScrollBar scrollbar, int numEntries, CallbackInfo ci) {
        this.labs$calcDistFor(updateList);
    }

    @Inject(method={"update"}, at={@At(value="INVOKE", target="Lcom/projecturanus/betterp2p/client/gui/InfoList;resort()V")}, require=1)
    private void checkInfoBeforeSort3(Collection<InfoWrapper> updateList, WidgetScrollBar scrollbar, int numEntries, CallbackInfo ci) {
        this.labs$checkInfo();
    }

    @Inject(method={"update"}, at={@At(value="INVOKE", target="Lcom/projecturanus/betterp2p/client/gui/widget/WidgetScrollBar;setRange(III)V")}, require=1, cancellable=true)
    private void replaceOldUpdateScrollbar(Collection<InfoWrapper> updateList, WidgetScrollBar scrollbar, int numEntries, CallbackInfo ci) {
        ci.cancel();
        this.labs$properlyResetScrollbar(scrollbar, numEntries);
    }

    @Inject(method={"resort"}, at={@At(value="HEAD")}, cancellable=true)
    private void customSortLogic(CallbackInfo ci) {
        Comparator<InfoWrapper> sorter = this.labs$sortMode.getComp(this.getSelectedInfo());
        if (this.labs$sortReversed) {
            sorter = sorter.reversed();
        }
        this.labs$getThis().getSorted().sort(sorter);
        ci.cancel();
    }

    @Inject(method={"refilter"}, at={@At(value="HEAD")}, cancellable=true)
    private void newFilterLogic(CallbackInfo ci) {
        ci.cancel();
        String toSearch = this.getSearchStr().trim();
        if (toSearch.isEmpty()) {
            this.labs$getThis().setFiltered((List)ImmutableList.copyOf((Collection)this.labs$getThis().getSorted()));
            return;
        }
        Comparator<InfoWrapper> sorter = this.labs$sortMode.getComp(this.getSelectedInfo());
        if (this.labs$sortReversed) {
            sorter = sorter.reversed();
        }
        this.filter.updateFilter(toSearch.toLowerCase());
        this.labs$getThis().setFiltered(this.labs$getThis().getSorted().stream().filter(info -> {
            if (this.getSelectedInfo() != null && info.getLoc().equals((Object)this.getSelectedInfo().getLoc())) {
                return true;
            }
            for (Map.Entry entry : this.filter.getActiveFilters().entrySet()) {
                if (entry.getKey() == Filter.BOUND) {
                    return info.getFrequency() != 0 && !info.getError();
                }
                if (((Boolean)((Filter)entry.getKey()).getFilter().invoke(info, (Object)((List)entry.getValue()))).booleanValue()) continue;
                return false;
            }
            return true;
        }).sorted(sorter).collect(Collectors.toList()));
    }

    @Unique
    private InfoList labs$getThis() {
        return (InfoList)this;
    }
}

