/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.betterp2p;

import com.nomiceu.nomilabs.integration.betterp2p.AccessibleInfoWrapper;
import com.nomiceu.nomilabs.util.LabsTranslate;
import com.projecturanus.betterp2p.BetterP2P;
import com.projecturanus.betterp2p.client.gui.InfoWrapper;
import com.projecturanus.betterp2p.network.data.P2PInfo;
import com.projecturanus.betterp2p.network.data.P2PLocation;
import com.projecturanus.betterp2p.util.p2p.TunnelInfo;
import java.util.List;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={InfoWrapper.class}, remap=false)
public class InfoWrapperMixin
implements AccessibleInfoWrapper {
    @Shadow
    @Final
    private P2PLocation loc;
    @Shadow
    private short frequency;
    @Shadow
    @Final
    @Mutable
    private String description;
    @Unique
    private int labs$connectionInfoIndex = 0;
    @Unique
    private double labs$distanceToPlayer = 0.0;
    @Unique
    private boolean labs$differentDim = false;
    @Unique
    private String labs$dimensionName = null;

    @Override
    @Unique
    public double labs$getDistance() {
        return this.labs$distanceToPlayer;
    }

    @Override
    @Unique
    public boolean labs$isDifferentDim() {
        return this.labs$differentDim;
    }

    @Override
    @Unique
    public String labs$getDimensionName() {
        if (this.labs$dimensionName != null) {
            return this.labs$dimensionName;
        }
        this.labs$dimensionName = DimensionManager.getProviderType((int)this.loc.getDim()).func_186065_b().replace("_", " ");
        this.labs$dimensionName = WordUtils.capitalizeFully((String)this.labs$dimensionName);
        return this.labs$dimensionName;
    }

    @Override
    @Unique
    public void labs$calculateDistance(Vec3d playerPos, int playerDim) {
        if (this.loc.getDim() != playerDim) {
            this.labs$differentDim = true;
            this.labs$distanceToPlayer = 0.0;
            return;
        }
        double x = (double)this.loc.getPos().func_177958_n() + 0.5;
        double y = (double)this.loc.getPos().func_177956_o() + 0.5;
        double z = (double)this.loc.getPos().func_177952_p() + 0.5;
        double mod = 0.4375;
        switch (this.loc.getFacing()) {
            case NORTH: {
                z -= mod;
                break;
            }
            case SOUTH: {
                z += mod;
                break;
            }
            case WEST: {
                x -= mod;
                break;
            }
            case EAST: {
                x += mod;
                break;
            }
            case UP: {
                y += mod;
                break;
            }
            case DOWN: {
                y -= mod;
            }
        }
        double distance = Math.sqrt(playerPos.func_186679_c(x, y, z));
        this.labs$distanceToPlayer = (double)Math.round(distance * 10.0) / 10.0;
    }

    @Override
    @Unique
    public void labs$setConnectionAmt(int amt) {
        List hover = this.labs$getThis().getHoverInfo();
        if (hover.size() > this.labs$connectionInfoIndex) {
            hover.remove(this.labs$connectionInfoIndex);
        }
        StringBuilder builder = new StringBuilder("nomilabs.gui.advanced_memory_card.hover_info.connections.");
        if (this.labs$getThis().getOutput()) {
            builder.append("input.");
        } else {
            builder.append("output.");
        }
        switch (amt) {
            case 0: {
                builder.append("none");
                break;
            }
            case 1: {
                builder.append("one");
                break;
            }
            default: {
                builder.append("multi");
            }
        }
        hover.add(LabsTranslate.translate(builder.toString(), amt));
    }

    @Inject(method={"setFrequency"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelChangeTooltip(short value, CallbackInfo ci) {
        this.frequency = value;
        ci.cancel();
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void provideChannelInfo(P2PInfo info, CallbackInfo ci) {
        TunnelInfo p2pType = BetterP2P.proxy.getP2PFromIndex(info.getType());
        if (p2pType == null) {
            return;
        }
        this.description = LabsTranslate.translate("nomilabs.gui.advanced_memory_card.info.type", p2pType.getDispName(), LabsTranslate.translate(info.getOutput() ? "gui.advanced_memory_card.p2p_status.output" : "gui.advanced_memory_card.p2p_status.input", new Object[0]));
        List hover = this.labs$getThis().getHoverInfo();
        hover.clear();
        hover.add(LabsTranslate.translate("nomilabs.gui.advanced_memory_card.hover_info.title", p2pType.getDispName()));
        hover.add(TextFormatting.YELLOW + LabsTranslate.translate("gui.advanced_memory_card.pos", info.getPos().func_177958_n(), info.getPos().func_177956_o(), info.getPos().func_177952_p()));
        hover.add(TextFormatting.YELLOW + LabsTranslate.translate("gui.advanced_memory_card.side", StringUtils.capitalize((String)info.getFacing().func_176742_j())));
        hover.add(TextFormatting.YELLOW + LabsTranslate.translate("nomilabs.gui.advanced_memory_card.hover_info.dim", this.labs$getDimensionName(), this.loc.getDim()));
        String channels = this.labs$getThis().getChannels();
        if (channels != null) {
            this.labs$getThis().getHoverInfo().add(TextFormatting.LIGHT_PURPLE + channels);
        }
        if (this.frequency == 0) {
            hover.add(TextFormatting.RED + LabsTranslate.translate("gui.advanced_memory_card.p2p_status.unbound", new Object[0]));
        } else {
            hover.add(TextFormatting.GREEN + LabsTranslate.translate("gui.advanced_memory_card.p2p_status.bound", new Object[0]));
        }
        if (!info.getHasChannel()) {
            hover.add("\u00a7c" + LabsTranslate.translate("gui.advanced_memory_card.p2p_status.offline", new Object[0]));
        }
        this.labs$connectionInfoIndex = hover.size();
    }

    @Inject(method={"getFreqDisplay"}, at={@At(value="HEAD")}, cancellable=true)
    private void getLabsFreqDisplay(CallbackInfoReturnable<String> cir) {
        StringBuilder builder = new StringBuilder();
        builder.append(LabsTranslate.translate("item.advanced_memory_card.selected", new Object[0])).append(" ");
        if (this.frequency == 0) {
            builder.append(LabsTranslate.translate("gui.advanced_memory_card.desc.not_set", new Object[0]));
        } else {
            builder.append(String.format("%04X", this.frequency));
        }
        cir.setReturnValue((Object)builder.toString());
    }

    @Unique
    private InfoWrapper labs$getThis() {
        return (InfoWrapper)this;
    }
}

