/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.betterp2p;

import com.projecturanus.betterp2p.client.gui.widget.WidgetScrollBar;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WidgetScrollBar.class}, remap=false)
public abstract class WidgetScrollBarMixin {
    @Shadow
    private int displayX;
    @Shadow
    private int width;
    @Shadow
    private int displayY;
    @Shadow
    private int height;
    @Shadow
    private int currentScroll;
    @Shadow
    private int minScroll;
    @Shadow
    private boolean moving;

    @Shadow
    protected abstract int getRange();

    @Shadow
    protected abstract void applyRange();

    @Inject(method={"click"}, at={@At(value="HEAD")}, cancellable=true)
    private void properlyHandleClick(int x, int y, CallbackInfo ci) {
        ci.cancel();
        if (this.getRange() == 0) {
            return;
        }
        if (y > this.displayY && y <= this.displayY + this.height && x > this.displayX && x <= this.displayX + this.width) {
            this.currentScroll = y - this.displayY;
            this.currentScroll = this.minScroll + this.currentScroll * 2 * this.getRange() / this.height;
            this.currentScroll = this.currentScroll + 1 >> 1;
            this.applyRange();
            this.moving = true;
        }
    }
}

