/*
 * Decompiled with CFR 0.152.
 */
package com.nomiceu.nomilabs.mixin.betterquesting;

import betterquesting.api.questing.IQuest;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.ParticipantInfo;
import betterquesting.questing.tasks.TaskFluid;
import com.nomiceu.nomilabs.config.LabsConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Tuple;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TaskFluid.class}, remap=false)
public abstract class TaskFluidMixin {
    @Shadow
    public boolean consume;
    @Shadow
    public boolean groupDetect;
    @Shadow
    @Final
    public NonNullList<FluidStack> requiredFluids;
    @Shadow
    public boolean ignoreNbt;

    @Shadow
    public abstract boolean isComplete(UUID var1);

    @Shadow
    protected abstract List<Tuple<UUID, int[]>> getBulkProgress(@NotNull List<UUID> var1);

    @Shadow
    protected abstract void setBulkProgress(@NotNull List<Tuple<UUID, int[]>> var1);

    @Shadow
    protected abstract void checkAndComplete(ParticipantInfo var1, DBEntry<IQuest> var2, boolean var3);

    @Inject(method={"detect"}, at={@At(value="HEAD")}, cancellable=true)
    private void replaceDetect(ParticipantInfo pInfo, DBEntry<IQuest> quest, CallbackInfo ci) {
        List<Object> invoList;
        if (!LabsConfig.modIntegration.enableBQuFluidTaskFixes) {
            return;
        }
        ci.cancel();
        if (this.isComplete(pInfo.UUID)) {
            return;
        }
        List<Tuple<UUID, int[]>> progress = this.getBulkProgress(this.consume ? Collections.singletonList(pInfo.UUID) : pInfo.ALL_UUIDS);
        boolean updated = false;
        if (!this.consume) {
            if (this.groupDetect) {
                progress.forEach(value -> Arrays.fill((int[])value.func_76340_b(), 0));
            } else {
                for (int i = 0; i < this.requiredFluids.size(); ++i) {
                    int r = ((FluidStack)this.requiredFluids.get((int)i)).amount;
                    for (Tuple<UUID, int[]> value2 : progress) {
                        int n = ((int[])value2.func_76340_b())[i];
                        if (n == 0 || n >= r) continue;
                        ((int[])value2.func_76340_b())[i] = 0;
                        updated = true;
                    }
                }
            }
        }
        if (this.consume) {
            invoList = Collections.singletonList(pInfo.PLAYER.field_71071_by);
        } else {
            invoList = new ArrayList();
            pInfo.ACTIVE_PLAYERS.forEach(p -> invoList.add(p.field_71071_by));
        }
        for (InventoryPlayer inventoryPlayer : invoList) {
            block3: for (int i = 0; i < inventoryPlayer.func_70302_i_(); ++i) {
                ItemStack stack = inventoryPlayer.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                ItemStack toRetrieveInfo = stack.func_77946_l();
                toRetrieveInfo.func_190920_e(1);
                IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)toRetrieveInfo);
                if (handler == null) continue;
                for (int j = 0; j < this.requiredFluids.size(); ++j) {
                    FluidStack rStack = (FluidStack)this.requiredFluids.get(j);
                    boolean hasDrained = false;
                    boolean requiresFullDrain = false;
                    int fullDrainAmt = 0;
                    FluidStack rStackOg = rStack.copy();
                    rStackOg.amount = (int)Math.ceil((double)rStack.amount / (double)stack.func_190916_E());
                    FluidStack sample = handler.drain(rStackOg, false);
                    if (sample == null || sample.amount <= 0) {
                        if (handler.getTankProperties().length < 1 || (fullDrainAmt = handler.getTankProperties()[0].getCapacity()) <= 0) continue;
                        rStackOg.amount = fullDrainAmt;
                        sample = handler.drain(rStackOg, false);
                        if (sample == null || sample.amount <= 0) continue;
                        requiresFullDrain = true;
                    }
                    for (Tuple<UUID, int[]> value3 : progress) {
                        FluidStack fluid;
                        if (((int[])value3.func_76340_b())[j] >= rStack.amount) continue;
                        int remaining = rStack.amount - ((int[])value3.func_76340_b())[j];
                        FluidStack drain = rStack.copy();
                        drain.amount = requiresFullDrain ? fullDrainAmt : (int)Math.ceil((double)remaining / (double)stack.func_190916_E());
                        if (this.ignoreNbt) {
                            drain.tag = null;
                        }
                        if (drain.amount <= 0 || (fluid = handler.drain(drain, this.consume)) == null || fluid.amount <= 0) continue;
                        int[] nArray = (int[])value3.func_76340_b();
                        int n = j;
                        nArray[n] = nArray[n] + Math.min(fluid.amount * stack.func_190916_E(), remaining);
                        hasDrained = true;
                        updated = true;
                    }
                    if (!hasDrained) continue;
                    if (!this.consume) continue block3;
                    ItemStack result = handler.getContainer();
                    result.func_190920_e(stack.func_190916_E());
                    inventoryPlayer.func_70299_a(i, result);
                    continue block3;
                }
            }
            if (updated) {
                this.setBulkProgress(progress);
            }
            this.checkAndComplete(pInfo, quest, updated);
        }
    }
}

